/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.StepBuilder;
import java.util.Stack;

public interface Locator {
    public StepBuilder<?> step();

    public BaseSequenceBuilder<?> sequence();

    public ScenarioBuilder scenario();

    public BenchmarkBuilder benchmark();

    public String locationMessage();

    public static Locator current() {
        Stack<Locator> stack = Holder.CURRENT.get();
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Locator is not set. This method must be invoked within the prepareBuild() or build() phase of scenario.");
        }
        return stack.peek();
    }

    public static boolean isAvailable() {
        Stack<Locator> stack = Holder.CURRENT.get();
        return !stack.isEmpty();
    }

    public static void push(Locator locator) {
        Holder.CURRENT.get().push(locator);
    }

    public static void push(StepBuilder<?> stepBuilder, BaseSequenceBuilder<?> sequenceBuilder) {
        Stack<Locator> stack = Holder.CURRENT.get();
        stack.push(new Impl(stepBuilder, sequenceBuilder, sequenceBuilder.endSequence()));
    }

    public static void push(ScenarioBuilder scenarioBuilder) {
        Stack<Locator> stack = Holder.CURRENT.get();
        stack.push(new Impl(null, null, scenarioBuilder));
    }

    public static void pop() {
        Holder.CURRENT.get().pop();
    }

    public static abstract class Abstract
    implements Locator {
        @Override
        public StepBuilder<?> step() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseSequenceBuilder<?> sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScenarioBuilder scenario() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BenchmarkBuilder benchmark() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String locationMessage() {
            return "";
        }
    }

    public static class Impl
    implements Locator {
        private final StepBuilder<?> step;
        private final BaseSequenceBuilder<?> sequence;
        private final ScenarioBuilder scenario;

        private Impl(StepBuilder<?> step, BaseSequenceBuilder<?> sequence, ScenarioBuilder scenario) {
            this.step = step;
            this.sequence = sequence;
            this.scenario = scenario;
        }

        @Override
        public StepBuilder<?> step() {
            return this.step;
        }

        @Override
        public BaseSequenceBuilder<?> sequence() {
            return this.sequence;
        }

        @Override
        public ScenarioBuilder scenario() {
            return this.scenario;
        }

        @Override
        public BenchmarkBuilder benchmark() {
            return this.scenario().endScenario().endPhase();
        }

        @Override
        public String locationMessage() {
            StringBuilder sb = new StringBuilder("Phase ").append(this.scenario().endScenario().name);
            String forkName = this.scenario().fork().name;
            if (forkName != null) {
                sb.append("/").append(forkName);
            }
            if (this.sequence != null) {
                sb.append(", sequence ").append(this.sequence.name());
            }
            if (this.step != null) {
                sb.append(", step ");
                sb.append(StepBuilder.nameOf(this.step));
                int stepIndex = this.sequence.indexOf(this.step);
                if (stepIndex >= 0) {
                    sb.append(" (").append(stepIndex).append("/").append(this.sequence.size()).append(")");
                }
            }
            return sb.toString();
        }
    }

    public static class Holder {
        private static final ThreadLocal<Stack<Locator>> CURRENT = ThreadLocal.withInitial(Stack::new);
    }
}

