/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Address;
import io.horizen.evm.EvmContext;
import io.horizen.evm.LibEvm;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.TraceOptions;
import io.horizen.evm.TracerOpCode;
import io.horizen.evm.params.TracerCreateParams;
import io.horizen.evm.params.TracerEndParams;
import io.horizen.evm.params.TracerEnterParams;
import io.horizen.evm.params.TracerExitParams;
import io.horizen.evm.params.TracerParams;
import io.horizen.evm.params.TracerStartParams;
import io.horizen.evm.params.TracerTxEndParams;
import io.horizen.evm.params.TracerTxStartParams;
import io.horizen.evm.results.TracerResult;
import java.math.BigInteger;

public class Tracer
extends ResourceHandle {
    public Tracer(TraceOptions options) {
        super(LibEvm.invoke("TracerCreate", new TracerCreateParams(options), Integer.TYPE));
    }

    @Override
    public void close() {
        LibEvm.invoke("TracerRemove", new TracerParams(this.handle));
    }

    public TracerResult getResult() {
        return LibEvm.invoke("TracerResult", new TracerParams(this.handle), TracerResult.class);
    }

    public void CaptureTxStart(BigInteger gasLimit) {
        LibEvm.invoke("TracerCaptureTxStart", new TracerTxStartParams(this.handle, gasLimit));
    }

    public void CaptureTxEnd(BigInteger restGas) {
        LibEvm.invoke("TracerCaptureTxEnd", new TracerTxEndParams(this.handle, restGas));
    }

    public void CaptureStart(ResourceHandle stateDBHandle, EvmContext context, Address from, Address to, boolean create, byte[] input, BigInteger gas, BigInteger value) {
        LibEvm.invoke("TracerCaptureStart", new TracerStartParams(this.handle, stateDBHandle.handle, context, from, to, create, input, gas, value));
    }

    public void CaptureEnd(byte[] output, BigInteger gasUsed, String err) {
        LibEvm.invoke("TracerCaptureEnd", new TracerEndParams(this.handle, output, gasUsed, err));
    }

    public void CaptureEnter(TracerOpCode opCode, Address from, Address to, byte[] input, BigInteger gas, BigInteger value) {
        LibEvm.invoke("TracerCaptureEnter", new TracerEnterParams(this.handle, opCode.getName(), from, to, input, gas, value));
    }

    public void CaptureExit(byte[] output, BigInteger gasUsed, String err) {
        LibEvm.invoke("TracerCaptureExit", new TracerExitParams(this.handle, output, gasUsed, err));
    }
}

