/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Address;
import io.horizen.evm.Database;
import io.horizen.evm.ForkRules;
import io.horizen.evm.Hash;
import io.horizen.evm.LibEvm;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.params.AccessParams;
import io.horizen.evm.params.AccountParams;
import io.horizen.evm.params.AddLogParams;
import io.horizen.evm.params.BalanceParams;
import io.horizen.evm.params.CodeParams;
import io.horizen.evm.params.GetLogsParams;
import io.horizen.evm.params.HandleParams;
import io.horizen.evm.params.NonceParams;
import io.horizen.evm.params.OpenStateParams;
import io.horizen.evm.params.ProofParams;
import io.horizen.evm.params.RefundParams;
import io.horizen.evm.params.SetStorageParams;
import io.horizen.evm.params.SetTxContextParams;
import io.horizen.evm.params.SlotParams;
import io.horizen.evm.params.SnapshotParams;
import io.horizen.evm.params.StorageParams;
import io.horizen.evm.results.EvmLog;
import io.horizen.evm.results.ProofAccountResult;
import java.math.BigInteger;

public class StateDB
extends ResourceHandle {
    public static final Hash EMPTY_CODE_HASH = new Hash("0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470");
    public static final Hash EMPTY_ROOT_HASH = new Hash("0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421");

    public StateDB(Database db, Hash root) {
        super(LibEvm.invoke("StateOpen", new OpenStateParams(db.handle, root.equals(Hash.ZERO) ? EMPTY_ROOT_HASH : root), Integer.TYPE));
    }

    @Override
    public void close() throws Exception {
        LibEvm.invoke("StateClose", new HandleParams(this.handle));
    }

    public void finalizeChanges() {
        LibEvm.invoke("StateFinalize", new HandleParams(this.handle));
    }

    public Hash getIntermediateRoot() {
        return LibEvm.invoke("StateIntermediateRoot", new HandleParams(this.handle), Hash.class);
    }

    public Hash commit() {
        return LibEvm.invoke("StateCommit", new HandleParams(this.handle), Hash.class);
    }

    public boolean isEmpty(Address address) {
        return LibEvm.invoke("StateEmpty", new AccountParams(this.handle, address), Boolean.TYPE);
    }

    public boolean isEoaAccount(Address address) {
        return LibEvm.invoke("StateIsEoa", new AccountParams(this.handle, address), Boolean.TYPE);
    }

    public boolean isSmartContractAccount(Address address) {
        return !this.isEoaAccount(address);
    }

    public BigInteger getBalance(Address address) {
        return LibEvm.invoke("StateGetBalance", new AccountParams(this.handle, address), BigInteger.class);
    }

    public void addBalance(Address address, BigInteger amount) {
        LibEvm.invoke("StateAddBalance", new BalanceParams(this.handle, address, amount));
    }

    public void subBalance(Address address, BigInteger amount) {
        LibEvm.invoke("StateSubBalance", new BalanceParams(this.handle, address, amount));
    }

    public void setBalance(Address address, BigInteger amount) {
        LibEvm.invoke("StateSetBalance", new BalanceParams(this.handle, address, amount));
    }

    public BigInteger getNonce(Address address) {
        return LibEvm.invoke("StateGetNonce", new AccountParams(this.handle, address), BigInteger.class);
    }

    public void setNonce(Address address, BigInteger nonce) {
        LibEvm.invoke("StateSetNonce", new NonceParams(this.handle, address, nonce));
    }

    public Hash getCodeHash(Address address) {
        return LibEvm.invoke("StateGetCodeHash", new AccountParams(this.handle, address), Hash.class);
    }

    public byte[] getCode(Address address) {
        return LibEvm.invoke("StateGetCode", new AccountParams(this.handle, address), byte[].class);
    }

    public void setCode(Address address, byte[] code) {
        LibEvm.invoke("StateSetCode", new CodeParams(this.handle, address, code));
    }

    public void addRefund(BigInteger gas) {
        LibEvm.invoke("RefundAdd", new RefundParams(this.handle, gas), Void.TYPE);
    }

    public void subRefund(BigInteger gas) {
        LibEvm.invoke("RefundSub", new RefundParams(this.handle, gas), Void.TYPE);
    }

    public BigInteger getRefund() {
        return LibEvm.invoke("RefundGet", new HandleParams(this.handle), BigInteger.class);
    }

    public Hash getStorage(Address address, Hash key) {
        return LibEvm.invoke("StateGetStorage", new StorageParams(this.handle, address, key), Hash.class);
    }

    public Hash getCommittedStorage(Address address, Hash key) {
        return LibEvm.invoke("StateGetCommittedStorage", new StorageParams(this.handle, address, key), Hash.class);
    }

    public void setStorage(Address address, Hash key, Hash value) {
        LibEvm.invoke("StateSetStorage", new SetStorageParams(this.handle, address, key, value));
    }

    public ProofAccountResult getProof(Address address, Hash root, Hash[] storageKeys) {
        return LibEvm.invoke("StateGetProof", new ProofParams(this.handle, address, root, storageKeys), ProofAccountResult.class);
    }

    public int snapshot() {
        return LibEvm.invoke("StateSnapshot", new HandleParams(this.handle), Integer.TYPE);
    }

    public void revertToSnapshot(int revisionId) {
        LibEvm.invoke("StateRevertToSnapshot", new SnapshotParams(this.handle, revisionId));
    }

    public EvmLog[] getLogs(Hash txHash) {
        return LibEvm.invoke("StateGetLogs", new GetLogsParams(this.handle, txHash), EvmLog[].class);
    }

    public void addLog(EvmLog evmLog) {
        LibEvm.invoke("StateAddLog", new AddLogParams(this.handle, evmLog));
    }

    public void setTxContext(Hash txHash, int txIndex) {
        LibEvm.invoke("StateSetTxContext", new SetTxContextParams(this.handle, txHash, txIndex));
    }

    public void accessSetup(Address sender, Address destination, Address coinbase, ForkRules rules) {
        LibEvm.invoke("AccessSetup", new AccessParams(this.handle, sender, destination, coinbase, rules));
    }

    public boolean accessAccount(Address address) {
        return LibEvm.invoke("AccessAccount", new AccountParams(this.handle, address), Boolean.class);
    }

    public boolean accessSlot(Address address, Hash slot) {
        return LibEvm.invoke("AccessSlot", new SlotParams(this.handle, address, slot), Boolean.class);
    }

    @Override
    public String toString() {
        return String.format("StateDB{handle=%d}", this.handle);
    }
}

