/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Converter;
import java.util.Arrays;

public class FixedSizeByteArray {
    private static final String PREFIX = "0x";
    private final int length;
    private final byte[] bytes;

    protected FixedSizeByteArray(int length, byte[] bytes) {
        if (bytes.length != length) {
            throw new IllegalArgumentException(String.format("invalid length: want %d bytes got %d", length, bytes.length));
        }
        this.length = length;
        this.bytes = Arrays.copyOf(bytes, length);
    }

    protected FixedSizeByteArray(int length, String hex) {
        if (!hex.startsWith(PREFIX)) {
            throw new IllegalArgumentException("hex string must be prefixed with 0x");
        }
        if (hex.length() != length * 2 + PREFIX.length()) {
            throw new IllegalArgumentException(String.format("invalid length: want %d hex characters got %d", length * 2 + PREFIX.length(), hex.length()));
        }
        this.length = length;
        this.bytes = Converter.fromHexString(hex.substring(2));
    }

    public String toString() {
        return PREFIX + Converter.toHexString(this.bytes);
    }

    public String toStringNoPrefix() {
        return Converter.toHexString(this.bytes);
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.bytes, this.length);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FixedSizeByteArray)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        FixedSizeByteArray other = (FixedSizeByteArray)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

