/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Address;
import io.horizen.evm.Database;
import io.horizen.evm.Hash;
import io.horizen.evm.LevelDBDatabase;
import io.horizen.evm.LibEvm;
import io.horizen.evm.LibEvmException;
import io.horizen.evm.LibEvmTestBase;
import io.horizen.evm.MemoryDatabase;
import io.horizen.evm.StateDB;
import io.horizen.evm.params.HandleParams;
import io.horizen.evm.params.OpenStateParams;
import io.horizen.evm.results.ProofAccountResult;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import sparkz.crypto.hash.Keccak256;

public class StateDBTest
extends LibEvmTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void accountManipulation() throws Exception {
        Hash rootWithBalance802;
        Hash rootWithBalance1234;
        StateDB statedb;
        File databaseFolder = this.tempFolder.newFolder("evm-db");
        Address origin = new Address("0xbafe3b6f2a19658df3cb5efca158c93272ff5c0b");
        BigInteger v1234 = BigInteger.valueOf(1234L);
        BigInteger v432 = BigInteger.valueOf(432L);
        BigInteger v802 = v1234.subtract(v432);
        BigInteger v3 = BigInteger.valueOf(3L);
        BigInteger v5 = BigInteger.valueOf(5L);
        try (LevelDBDatabase db = new LevelDBDatabase(databaseFolder.getAbsolutePath());){
            statedb = new StateDB((Database)db, Hash.ZERO);
            try {
                Hash intermediateRoot = statedb.getIntermediateRoot();
                Assert.assertEquals((String)"empty state should give the hash of an empty string as the root hash", (Object)StateDB.EMPTY_ROOT_HASH, (Object)intermediateRoot);
                Hash committedRoot = statedb.commit();
                Assert.assertEquals((String)"committed root should equal intermediate root", (Object)intermediateRoot, (Object)committedRoot);
                Assert.assertEquals((Object)BigInteger.ZERO, (Object)statedb.getBalance(origin));
                statedb.addBalance(origin, v1234);
                Assert.assertEquals((Object)v1234, (Object)statedb.getBalance(origin));
                Assert.assertNotEquals((String)"intermediate root should not equal committed root anymore", (Object)committedRoot, (Object)statedb.getIntermediateRoot());
                rootWithBalance1234 = statedb.commit();
                int revisionId = statedb.snapshot();
                statedb.subBalance(origin, v432);
                Assert.assertEquals((Object)v802, (Object)statedb.getBalance(origin));
                statedb.revertToSnapshot(revisionId);
                Assert.assertEquals((Object)v1234, (Object)statedb.getBalance(origin));
                statedb.subBalance(origin, v432);
                Assert.assertEquals((Object)v802, (Object)statedb.getBalance(origin));
                Assert.assertEquals((Object)BigInteger.ZERO, (Object)statedb.getNonce(origin));
                statedb.setNonce(origin, v3);
                Assert.assertEquals((Object)v3, (Object)statedb.getNonce(origin));
                rootWithBalance802 = statedb.commit();
                statedb.setNonce(origin, v5);
                Assert.assertEquals((Object)v5, (Object)statedb.getNonce(origin));
            }
            finally {
                statedb.close();
            }
            Assert.assertThrows(Exception.class, () -> ((Hash)LibEvm.invoke((String)"StateIntermediateRoot", (Object)new HandleParams(1), Hash.class)).toBytes());
        }
        Assert.assertThrows(Exception.class, () -> LibEvm.invoke((String)"StateOpen", (Object)new OpenStateParams(1, Hash.ZERO), Integer.TYPE));
        db = new LevelDBDatabase(databaseFolder.getAbsolutePath());
        try {
            statedb = new StateDB((Database)db, rootWithBalance1234);
            try {
                Assert.assertEquals((Object)v1234, (Object)statedb.getBalance(origin));
                Assert.assertEquals((Object)BigInteger.ZERO, (Object)statedb.getNonce(origin));
            }
            finally {
                statedb.close();
            }
            statedb = new StateDB((Database)db, rootWithBalance802);
            try {
                Assert.assertEquals((Object)v802, (Object)statedb.getBalance(origin));
                Assert.assertEquals((Object)v3, (Object)statedb.getNonce(origin));
            }
            finally {
                statedb.close();
            }
        }
        finally {
            db.close();
        }
    }

    @Test
    public void accountStorage() throws Exception {
        Hash initialRoot;
        File databaseFolder = this.tempFolder.newFolder("account-db");
        Address origin = new Address("0xbafe3b6f2a19658df3cb5efca158c93272ff5cff");
        Hash key = new Hash("0xbafe3b6f2a19658df3cb5efca158c93272ff5cff010101010101010102020202");
        Hash[] values = new Hash[]{new Hash("0x0000000000000000000000000000000000000000000000000000000000000000"), new Hash("0x0000000000000000000000001234000000000000000000000000000000000000"), new Hash("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"), new Hash("0x00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff")};
        ArrayList<Hash> roots = new ArrayList<Hash>();
        try (LevelDBDatabase db = new LevelDBDatabase(databaseFolder.getAbsolutePath());
             StateDB statedb = new StateDB((Database)db, StateDB.EMPTY_ROOT_HASH);){
            Assert.assertTrue((String)"account must not exist in an empty state", (boolean)statedb.isEmpty(origin));
            statedb.setNonce(origin, BigInteger.ONE);
            Assert.assertFalse((String)"account must exist after nonce increment", (boolean)statedb.isEmpty(origin));
            initialRoot = statedb.getIntermediateRoot();
            for (Hash value : values) {
                statedb.setStorage(origin, key, value);
                Hash retrievedValue = statedb.getStorage(origin, key);
                Assert.assertEquals((Object)value, (Object)retrievedValue);
                roots.add(statedb.commit());
                Hash committedValue = statedb.getStorage(origin, key);
                Assert.assertEquals((Object)value, (Object)committedValue);
            }
        }
        db = new LevelDBDatabase(databaseFolder.getAbsolutePath());
        try {
            for (int i = 0; i < values.length; ++i) {
                try (StateDB statedb = new StateDB((Database)db, (Hash)roots.get(i));){
                    Hash writtenValue = statedb.getStorage(origin, key);
                    Assert.assertEquals((Object)values[i], (Object)writtenValue);
                    statedb.setStorage(origin, key, null);
                    Assert.assertEquals((Object)initialRoot, (Object)statedb.getIntermediateRoot());
                    continue;
                }
            }
        }
        finally {
            db.close();
        }
    }

    @Test
    public void accountStorageEdgeCases() throws Exception {
        Address origin = new Address("0xbafe3b6f2a19658df3cb5efca158c93272ff5cff");
        Hash key = new Hash("0xbafe3b6f2a19658df3cb5efca158c93272ff5cff010101010101010102020202");
        Hash validValue = new Hash("0x00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff");
        try (MemoryDatabase db = new MemoryDatabase();
             StateDB statedb = new StateDB((Database)db, StateDB.EMPTY_ROOT_HASH);){
            Assert.assertTrue((String)"account must not exist in an empty state", (boolean)statedb.isEmpty(origin));
            Assert.assertThrows(LibEvmException.class, () -> statedb.setStorage(origin, key, validValue));
            statedb.setNonce(origin, BigInteger.ONE);
            Assert.assertEquals((String)"reading a non-existent key should return all zeroes", (Object)Hash.ZERO, (Object)statedb.getStorage(origin, key));
            statedb.setStorage(origin, key, validValue);
            Assert.assertEquals((String)"value was not written correctly", (Object)validValue, (Object)statedb.getStorage(origin, key));
            Assert.assertEquals((String)"unexpected change of written value", (Object)validValue, (Object)statedb.getStorage(origin, key));
            statedb.setStorage(origin, key, null);
            Assert.assertEquals((String)"value should be all zeroes", (Object)Hash.ZERO, (Object)statedb.getStorage(origin, key));
            statedb.setStorage(origin, key, validValue);
            statedb.setStorage(origin, key, Hash.ZERO);
            Assert.assertEquals((String)"value should be all zeroes", (Object)Hash.ZERO, (Object)statedb.getStorage(origin, key));
        }
    }

    private void testAccessListAccounts(StateDB statedb, Address sender, Address destination, Address other) {
        Hash key1 = new Hash("0xbafe3b6f2a19658df3cb5efca158c93272ff5cff000000000000000000000001");
        Hash key2 = new Hash("0xbafe3b6f2a19658df3cb5efca158c93272ff5cff000000000000000000000002");
        statedb.accessSetup(sender, destination);
        Assert.assertTrue((String)"sender must be on access list", (boolean)statedb.accessAccount(sender));
        Assert.assertTrue((String)"destination must be on access list", (boolean)statedb.accessAccount(destination));
        Assert.assertFalse((String)"sender storage slot must not be on access list before first access", (boolean)statedb.accessSlot(sender, key1));
        Assert.assertTrue((String)"sender storage slot must be on access list after first access", (boolean)statedb.accessSlot(sender, key1));
        Assert.assertFalse((String)"sender storage slot must not be on access list before first access", (boolean)statedb.accessSlot(sender, key2));
        Assert.assertTrue((String)"sender storage slot must be on access list after first access", (boolean)statedb.accessSlot(sender, key2));
        Assert.assertFalse((String)"other account must not be on access list before first access", (boolean)statedb.accessAccount(other));
        Assert.assertTrue((String)"other account must be on access list after first acccess", (boolean)statedb.accessAccount(other));
        Assert.assertFalse((String)"other storage slot must not be on access list before first access", (boolean)statedb.accessSlot(other, key1));
        Assert.assertTrue((String)"other storage slot must be on access list after first access", (boolean)statedb.accessSlot(other, key1));
    }

    @Test
    public void accessList() throws Exception {
        Address[] accounts = new Address[]{new Address("0x0011001100110011001100110011001100110011"), new Address("0x0022002200220022002200220022002200220022"), new Address("0x0033003300330033003300330033003300330033")};
        try (MemoryDatabase db = new MemoryDatabase();
             StateDB statedb = new StateDB((Database)db, StateDB.EMPTY_ROOT_HASH);){
            this.testAccessListAccounts(statedb, accounts[0], accounts[1], accounts[2]);
            this.testAccessListAccounts(statedb, accounts[1], accounts[2], accounts[0]);
            this.testAccessListAccounts(statedb, accounts[2], accounts[0], accounts[1]);
            this.testAccessListAccounts(statedb, accounts[0], accounts[2], accounts[1]);
            this.testAccessListAccounts(statedb, accounts[1], accounts[0], accounts[2]);
        }
    }

    @Test
    public void testAccountTypes() throws Exception {
        byte[] code = StateDBTest.bytes("aa87aee0394326416058ef46b907882903f3646ef2a6d0d20f9e705b87c58c77");
        Address addr1 = new Address("0x1234561234561234561234561234561234561230");
        try (MemoryDatabase db = new MemoryDatabase();
             StateDB statedb = new StateDB((Database)db, Hash.ZERO);){
            Assert.assertTrue((String)"EOA account expected", (boolean)statedb.isEoaAccount(addr1));
            Assert.assertFalse((String)"EOA account expected", (boolean)statedb.isSmartContractAccount(addr1));
            statedb.addBalance(addr1, BigInteger.TEN);
            Assert.assertTrue((String)"EOA account expected", (boolean)statedb.isEoaAccount(addr1));
            Assert.assertFalse((String)"EOA account expected", (boolean)statedb.isSmartContractAccount(addr1));
            statedb.setCode(addr1, code);
            Assert.assertFalse((String)"Smart contract account expected", (boolean)statedb.isEoaAccount(addr1));
            Assert.assertTrue((String)"Smart contract account expected", (boolean)statedb.isSmartContractAccount(addr1));
        }
    }

    @Test
    public void proof() throws Exception {
        Address address = new Address("0xcca577ee56d30a444c73f8fc8d5ce34ed1c7da8b");
        try (MemoryDatabase db = new MemoryDatabase();
             StateDB statedb = new StateDB((Database)db, Hash.ZERO);){
            statedb.addBalance(address, BigInteger.TEN);
            statedb.setStorage(address, Hash.ZERO, StateDBTest.padToHash(RlpEncoder.encode((RlpType)RlpString.create((byte[])StateDBTest.bytes("94de74da73d5102a796559933296c73e7d1c6f37fb")))));
            statedb.setStorage(address, new Hash(Keccak256.hash((byte[])StateDBTest.bytes("0000000000000000000000000000000000000000000000000000000000000001"))), StateDBTest.padToHash(RlpEncoder.encode((RlpType)RlpString.create((byte[])StateDBTest.bytes("02")))));
            statedb.commit();
            ProofAccountResult resultA = statedb.getProof(address, null);
            Assert.assertEquals((Object)BigInteger.TEN, (Object)resultA.balance);
            Assert.assertEquals((long)1L, (long)resultA.accountProof.length);
            Assert.assertEquals((long)0L, (long)resultA.storageProof.length);
            ProofAccountResult resultB = statedb.getProof(address, new Hash[]{Hash.ZERO});
            Assert.assertEquals((Object)BigInteger.TEN, (Object)resultB.balance);
            Assert.assertEquals((long)1L, (long)resultB.accountProof.length);
            Assert.assertEquals((long)1L, (long)resultB.storageProof.length);
            Assert.assertEquals((long)2L, (long)resultB.storageProof[0].proof.length);
            Assert.assertEquals((Object)"0xf8518080a0cd5ca8a057cdc46dd649378e1cfbf1e166d25321c859d2918c955c48baf18f2d8080808080808080a08b7da99e493f28ab906f59591750bb1f2058beb82ab748f1cc2b66d4cf499f608080808080", (Object)resultB.storageProof[0].proof[0]);
            Assert.assertEquals((Object)"0xf839a0390decd9548b62a8d60345a988386fc84ba6bc95484008f6362f93160ef3e56397969594de74da73d5102a796559933296c73e7d1c6f37fb", (Object)resultB.storageProof[0].proof[1]);
        }
    }
}

