/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.EvmTest;
import io.horizen.evm.LibEvmTestBase;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LoadTest
extends LibEvmTestBase {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final long BYTE_TO_MB_CONVERSION_VALUE = 0x100000L;
    private static final EvmTest test = new EvmTest();

    private static long getCurrentlyUsedMemory() {
        System.gc();
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    private static ExecutorService startLoadTasks(int tasks) {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(tasks);
        for (int i = 0; i < tasks; ++i) {
            executor.scheduleAtFixedRate(new LoadTask(), 1000L, 100L, TimeUnit.MILLISECONDS);
        }
        executor.scheduleAtFixedRate(new StatusTask(), 0L, 1000L, TimeUnit.MILLISECONDS);
        return executor;
    }

    private static void runLoadTest(int tasks, int duration) throws Exception {
        ExecutorService executor = LoadTest.startLoadTasks(tasks);
        Thread.sleep(duration);
        executor.shutdown();
        Assert.assertTrue((String)"timeout while stopping load tasks", (boolean)executor.awaitTermination(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Ignore
    public void lowLoad() throws Exception {
        LoadTest.runLoadTest(1, 3000);
    }

    @Test
    @Ignore
    public void highLoad() throws Exception {
        LoadTest.runLoadTest(32, 10000);
    }

    public static void main(String[] args) throws Exception {
        int tasks = 32;
        if (args.length > 0) {
            tasks = Integer.parseInt(args[0]);
        }
        System.err.printf("starting load tasks: %d%n", tasks);
        ExecutorService executor = LoadTest.startLoadTasks(tasks);
        try {
            System.in.read();
        }
        finally {
            System.err.println("interrupted, stopping load tasks");
            executor.shutdown();
            if (!executor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                System.err.println("timeout while stopping load tasks");
            }
        }
    }

    private static class LoadTask
    extends TimerTask {
        private LoadTask() {
        }

        @Override
        public void run() {
            try {
                test.blockHashCallback();
                counter.getAndIncrement();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class StatusTask
    extends TimerTask {
        private StatusTask() {
        }

        @Override
        public void run() {
            System.err.printf("used memory: %d MB iterations: %d%n", LoadTest.getCurrentlyUsedMemory(), counter.get());
        }
    }
}

