/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class CgiData
extends LinkedHashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1006793090880571738L;
    public static final String AUTH_TYPE_KEY = "AUTH_TYPE";
    public static final String CONTENT_LENGTH_KEY = "CONTENT_LENGTH";
    public static final String CONTENT_TYPE_KEY = "CONTENT_TYPE";
    public static final String GATEWAY_INTERFACE_KEY = "GATEWAY_INTERFACE";
    public static final String HTTP_ACCEPT_KEY = "HTTP_ACCEPT";
    public static final String HTTP_ACCEPT_CHARSET_KEY = "HTTP_ACCEPT_CHARSET";
    public static final String HTTP_ACCEPT_ENCODING_KEY = "HTTP_ACCEPT_ENCODING";
    public static final String HTTP_ACCEPT_LANGUAGE_KEY = "HTTP_ACCEPT_LANGUAGE";
    public static final String HTTP_COOKIE_KEY = "HTTP_COOKIE";
    public static final String HTTP_USER_AGENT_KEY = "HTTP_USER_AGENT";
    public static final String PATH_INFO_KEY = "PATH_INFO";
    public static final String PATH_TRANSLATED_KEY = "PATH_TRANSLATED";
    public static final String QUERY_STRING_KEY = "QUERY_STRING";
    public static final String REMOTE_ADDR_KEY = "REMOTE_ADDR";
    public static final String REMOTE_HOST_KEY = "REMOTE_HOST";
    public static final String REMOTE_IDENT_KEY = "REMOTE_IDENT";
    public static final String REMOTE_PORT_KEY = "REMOTE_PORT";
    public static final String REMOTE_USER_KEY = "REMOTE_USER";
    public static final String REQUEST_METHOD_KEY = "REQUEST_METHOD";
    public static final String SCRIPT_NAME_KEY = "SCRIPT_NAME";
    public static final String SERVER_NAME_KEY = "SERVER_NAME";
    public static final String SERVER_PORT_KEY = "SERVER_PORT";
    public static final String SERVER_PROTOCOL_KEY = "SERVER_PROTOCOL";
    public static final String SERVER_SOFTWARE_KEY = "SERVER_SOFTWARE";
    public static final Map<String, String> HTTP_HEADER_NAMES_TO_CGI;

    public Map<String, String> addFromHttpHeaders(Map<String, String> headers) {
        return this.addFromHttpHeaders(headers, Objects::toString);
    }

    public <V> Map<String, V> addFromHttpHeaders(Map<String, V> headers, Function<V, String> toStringFunction) {
        Set<Map.Entry<String, V>> entries = headers.entrySet();
        LinkedHashMap<String, V> notMatched = new LinkedHashMap<String, V>(entries.size());
        for (Map.Entry<String, V> entry : entries) {
            String key = entry.getKey().toLowerCase();
            String cgiKey = HTTP_HEADER_NAMES_TO_CGI.get(key);
            if (cgiKey != null) {
                this.put(cgiKey, toStringFunction.apply(entry.getValue()));
                continue;
            }
            notMatched.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(notMatched);
    }

    public CgiData setAuthType(Object accept) {
        this.put(HTTP_ACCEPT_KEY, accept);
        return this;
    }

    public CgiData setHttpAccept(Object acceptCharset) {
        this.put(HTTP_ACCEPT_CHARSET_KEY, acceptCharset);
        return this;
    }

    public CgiData setContentLength(Object contentLength) {
        this.put(CONTENT_LENGTH_KEY, contentLength);
        return this;
    }

    public CgiData setContentLength(long contentLength) {
        this.put(CONTENT_LENGTH_KEY, Long.toString(contentLength));
        return this;
    }

    public CgiData setContentType(Object contentType) {
        this.put(CONTENT_TYPE_KEY, contentType);
        return this;
    }

    public CgiData setGatewayInterface(Object gatewayInterface) {
        this.put(GATEWAY_INTERFACE_KEY, gatewayInterface);
        return this;
    }

    public CgiData setHttpAcceptCharset(Object acceptCharset) {
        this.put(HTTP_ACCEPT_CHARSET_KEY, acceptCharset);
        return this;
    }

    public CgiData setHttpAcceptLanguage(Object acceptLanguage) {
        this.put(HTTP_ACCEPT_LANGUAGE_KEY, acceptLanguage);
        return this;
    }

    public CgiData setHttpAcceptEncoding(Object acceptEncoding) {
        this.put(HTTP_ACCEPT_ENCODING_KEY, acceptEncoding);
        return this;
    }

    public CgiData setHttpCookie(Object cookie) {
        this.put(HTTP_COOKIE_KEY, cookie);
        return this;
    }

    public CgiData setHttpUserAgent(Object userAgent) {
        this.put(HTTP_USER_AGENT_KEY, userAgent);
        return this;
    }

    public CgiData setPathInfo(Object pathInfo) {
        this.put(PATH_INFO_KEY, pathInfo);
        return this;
    }

    public CgiData setPathTranslated(Object pathTranslated) {
        this.put(PATH_TRANSLATED_KEY, pathTranslated);
        return this;
    }

    public CgiData setQueryString(Object queryString) {
        this.put(QUERY_STRING_KEY, queryString);
        return this;
    }

    public CgiData setRemoteAddr(Object remoteAddr) {
        this.put(REMOTE_ADDR_KEY, remoteAddr);
        return this;
    }

    public CgiData setRemoteHost(Object remoteHost) {
        this.put(REMOTE_HOST_KEY, remoteHost);
        return this;
    }

    public CgiData setRemoteIdent(Object remoteIdent) {
        this.put(REMOTE_IDENT_KEY, remoteIdent);
        return this;
    }

    public CgiData setRemotePort(Object remotePort) {
        this.put(REMOTE_PORT_KEY, remotePort);
        return this;
    }

    public CgiData setRemoteUser(Object remoteUser) {
        this.put(REMOTE_USER_KEY, remoteUser);
        return this;
    }

    public CgiData setRequestMethod(Object requestMethod) {
        this.put(REQUEST_METHOD_KEY, requestMethod);
        return this;
    }

    public CgiData setScriptName(Object scriptName) {
        this.put(SCRIPT_NAME_KEY, scriptName);
        return this;
    }

    public CgiData setServerName(Object serverName) {
        this.put(SERVER_NAME_KEY, serverName);
        return this;
    }

    public CgiData setServerPort(Object serverPort) {
        this.put(SERVER_PORT_KEY, serverPort);
        return this;
    }

    public CgiData setServerProtocol(Object serverProtocol) {
        this.put(SERVER_PROTOCOL_KEY, serverProtocol);
        return this;
    }

    public CgiData setServerSoftware(Object serverSoftware) {
        this.put(SERVER_SOFTWARE_KEY, serverSoftware);
        return this;
    }

    public Integer getAsInteger(String key) {
        Object value = this.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    static {
        HashMap<String, String> cgiToHttp = new HashMap<String, String>(8);
        cgiToHttp.put("Authorization".toLowerCase(), AUTH_TYPE_KEY);
        cgiToHttp.put("Content-Length".toLowerCase(), CONTENT_LENGTH_KEY);
        cgiToHttp.put("Content-Type".toLowerCase(), CONTENT_TYPE_KEY);
        cgiToHttp.put("Accept-Charset".toLowerCase(), HTTP_ACCEPT_CHARSET_KEY);
        cgiToHttp.put("Accept-Encoding".toLowerCase(), HTTP_ACCEPT_ENCODING_KEY);
        cgiToHttp.put("Accept".toLowerCase(), HTTP_ACCEPT_KEY);
        cgiToHttp.put("Accept-Language".toLowerCase(), HTTP_ACCEPT_LANGUAGE_KEY);
        cgiToHttp.put("User-Agent".toLowerCase(), HTTP_USER_AGENT_KEY);
        HTTP_HEADER_NAMES_TO_CGI = Collections.unmodifiableMap(cgiToHttp);
    }
}

