/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Backtrace;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Cause
implements Serializable {
    private static final long serialVersionUID = -6876640270344752492L;
    @JsonProperty(value="class")
    private final String className;
    private final String message;
    private final Backtrace backtrace;

    public Cause(ConfigContext config, Throwable error) {
        this.className = error.getClass().getName();
        this.message = error.getMessage();
        this.backtrace = new Backtrace(config, error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Cause)) {
            return false;
        }
        Cause cause = (Cause)o;
        return Objects.equals(this.getClassName(), cause.getClassName()) && Objects.equals(this.getMessage(), cause.getMessage()) && Objects.equals(this.getBacktrace(), cause.getBacktrace());
    }

    public int hashCode() {
        return Objects.hash(this.getClassName(), this.getMessage(), this.getBacktrace());
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public Backtrace getBacktrace() {
        return this.backtrace;
    }
}

