/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter;

import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.config.SystemSettingsConfigContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoneybadgerUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private ConfigContext config;
    private NoticeReporter reporter;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public HoneybadgerUncaughtExceptionHandler() {
        this(new SystemSettingsConfigContext());
    }

    public HoneybadgerUncaughtExceptionHandler(ConfigContext config) {
        this.setConfig(config);
        this.setReporter(new HoneybadgerReporter(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        NoticeReportResult errorResult = null;
        try {
            errorResult = this.getReporter().reportError(e);
        }
        catch (RuntimeException re) {
            block7: {
                try {
                    if (!this.getLogger().isErrorEnabled()) break block7;
                    this.getLogger().error("An error occurred when sending data to the Honeybadger API", (Throwable)re);
                }
                catch (Throwable throwable) {
                    if (this.getLogger().isErrorEnabled()) {
                        String msg = "An unhandled exception has occurred [%s]";
                        String id = errorResult == null ? "no-id" : errorResult.getId().toString();
                        this.getLogger().error(String.format(msg, id), e);
                    }
                    throw throwable;
                }
            }
            if (this.getLogger().isErrorEnabled()) {
                String msg = "An unhandled exception has occurred [%s]";
                String id = errorResult == null ? "no-id" : errorResult.getId().toString();
                this.getLogger().error(String.format(msg, id), e);
            }
        }
        if (this.getLogger().isErrorEnabled()) {
            String msg = "An unhandled exception has occurred [%s]";
            String id = errorResult == null ? "no-id" : errorResult.getId().toString();
            this.getLogger().error(String.format(msg, id), e);
        }
    }

    public NoticeReporter getReporter() {
        return this.reporter;
    }

    public ConfigContext getConfig() {
        return this.config;
    }

    public static HoneybadgerUncaughtExceptionHandler registerAsUncaughtExceptionHandler() {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(handler);
        return handler;
    }

    public static void registerAsUncaughtExceptionHandler(ConfigContext configContext) {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler(configContext);
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public static void registerAsUncaughtExceptionHandler(Thread t) {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
    }

    public static void registerAsUncaughtExceptionHandler(ConfigContext configContext, Thread t) {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler(configContext);
        t.setUncaughtExceptionHandler(handler);
    }

    protected void setConfig(ConfigContext config) {
        this.config = config;
    }

    protected void setReporter(NoticeReporter reporter) {
        this.reporter = reporter;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }
}

