/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.spring;

import io.honeybadger.reporter.FeedbackForm;
import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import io.honeybadger.reporter.config.SpringConfigContext;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class HoneybadgerSpringExceptionHandler {
    private final SpringConfigContext context;
    private final NoticeReporter reporter;
    private final FeedbackForm feedbackForm;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public HoneybadgerSpringExceptionHandler(SpringConfigContext context) {
        this.context = context;
        this.reporter = new HoneybadgerReporter(context);
        this.feedbackForm = new FeedbackForm(context);
    }

    protected boolean acceptsOnlyJson(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaders("Accept");
        if (enumeration == null) {
            return false;
        }
        if (!enumeration.hasMoreElements()) {
            return false;
        }
        ArrayList accepts = Collections.list(enumeration);
        if (accepts.size() == 1) {
            return ((String)accepts.get(0)).equals(MediaType.APPLICATION_JSON.toString());
        }
        return false;
    }

    protected String jsonErrorString(UUID errorId) throws IOException {
        return String.format("{ error_id : \"%s\" }", errorId);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<String> defaultErrorHandler(HttpServletRequest request, Exception exception) throws Exception {
        String msg;
        if (AnnotationUtils.findAnnotation(exception.getClass(), ResponseStatus.class) != null) {
            throw exception;
        }
        if (this.context.getExcludedClasses().contains(exception.getClass().getName())) {
            throw exception;
        }
        NoticeReportResult result = this.getReporter().reportError(exception, request);
        if (this.logger.isErrorEnabled()) {
            msg = String.format("Internal server error [honeybadger-id: %s]", result.getId());
            this.logger.error(msg, (Throwable)exception);
        }
        if (!this.getContext().isFeedbackFormDisplayed().booleanValue()) {
            msg = "Internal server error";
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)msg);
        }
        if (this.acceptsOnlyJson(request)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)this.jsonErrorString(result.getId()));
        }
        StringWriter writer = new StringWriter();
        Locale locale = request.getLocale();
        this.getFeedbackForm().renderHtml(result.getId(), exception.getMessage(), writer, locale);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_HTML).body((Object)((Object)writer).toString());
    }

    protected SpringConfigContext getContext() {
        return this.context;
    }

    protected NoticeReporter getReporter() {
        return this.reporter;
    }

    protected FeedbackForm getFeedbackForm() {
        return this.feedbackForm;
    }
}

