/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.honeybadger.util.HBStringUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Memory
implements Serializable {
    private static final long serialVersionUID = -8799953046383217102L;
    private static final String LINUX_MEMINFO_PATH = "/proc/meminfo";
    public static final int JVM_INFO_INITIAL_CAPACITY = 10;
    private final Number total;
    private final Number free;
    private final Number buffers;
    private final Number cached;
    @JsonProperty(value="vm_free_total")
    private final Number freeTotal;
    @JsonProperty(value="vm_free")
    private final Number vmFree;
    @JsonProperty(value="vm_max")
    private final Number vmMax;
    @JsonProperty(value="vm_total")
    private final Number vmTotal;
    @JsonProperty(value="vm_heap")
    private final Number vmHeap;
    @JsonProperty(value="vm_nonheap")
    private final Number vmNonheap;

    public Memory() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String os = osBean.getName();
        HashMap memValues = os.equals("Linux") ? Memory.findLinuxMemInfo(new File(LINUX_MEMINFO_PATH)) : new HashMap();
        Map<String, Number> vmMemValues = Memory.findJvmMemInfo();
        this.total = (Number)memValues.get("MemTotal");
        this.free = (Number)memValues.get("MemFree");
        this.buffers = (Number)memValues.get("Buffers");
        this.cached = (Number)memValues.get("Cached");
        this.freeTotal = (Number)memValues.get("FreeTotal");
        this.vmFree = vmMemValues.get("VmFreeMem");
        this.vmMax = vmMemValues.get("VmMaxMem");
        this.vmTotal = vmMemValues.get("VmTotalMem");
        this.vmHeap = vmMemValues.get("VmHeap");
        this.vmNonheap = vmMemValues.get("VmNonHeap");
    }

    @JsonCreator
    public Memory(@JsonProperty(value="total") Number total, @JsonProperty(value="free") Number free, @JsonProperty(value="buffers") Number buffers, @JsonProperty(value="cached") Number cached, @JsonProperty(value="free_total") Number freeTotal, @JsonProperty(value="vm_free") Number vmFree, @JsonProperty(value="vm_max") Number vmMax, @JsonProperty(value="vm_total") Number vmTotal, @JsonProperty(value="vm_heap") Number vmHeap, @JsonProperty(value="vm_nonheap") Number vmNonheap) {
        this.total = total;
        this.free = free;
        this.buffers = buffers;
        this.cached = cached;
        this.freeTotal = freeTotal;
        this.vmFree = vmFree;
        this.vmMax = vmMax;
        this.vmTotal = vmTotal;
        this.vmHeap = vmHeap;
        this.vmNonheap = vmNonheap;
    }

    static Map<String, Long> findLinuxMemInfo(File memInfoFile) {
        HashMap<String, Long> memInfo = new HashMap<String, Long>(50);
        long mebibyteMultiplier = 1024L;
        if (memInfoFile.exists() && memInfoFile.isFile() && memInfoFile.canRead()) {
            try (Scanner scanner = new Scanner(memInfoFile, StandardCharsets.US_ASCII.name());){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    String[] fields = line.split("(:?)\\s+", 3);
                    String name = fields[0];
                    String kbValue = fields[1];
                    Long mbValue = Long.parseLong(kbValue) / 1024L;
                    if (!HBStringUtils.isPresent(name) || !HBStringUtils.isPresent(kbValue)) continue;
                    memInfo.put(name, mbValue);
                }
                long free = memInfo.getOrDefault("MemFree", 0L);
                long buffers = memInfo.getOrDefault("Buffers", 0L);
                long cached = memInfo.getOrDefault("Cached", 0L);
                long freeTotal = free + buffers + cached;
                memInfo.put("FreeTotal", freeTotal);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Memory.class).error("Error reading memory information", (Throwable)e);
            }
        } else {
            LoggerFactory.getLogger(Memory.class).warn("Error reading memory information from {}", (Object)memInfoFile);
        }
        return memInfo;
    }

    static Map<String, Number> findJvmMemInfo() {
        HashMap<String, Number> jvmInfo = new HashMap<String, Number>(10);
        Runtime runtime = Runtime.getRuntime();
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        long mebibyte = 0x100000L;
        jvmInfo.put("VmFreeMem", runtime.freeMemory() / 0x100000L);
        jvmInfo.put("VmMaxMem", runtime.maxMemory() / 0x100000L);
        jvmInfo.put("VmTotalMem", runtime.totalMemory() / 0x100000L);
        jvmInfo.put("VmHeap", memBean.getHeapMemoryUsage().getUsed() / 0x100000L);
        jvmInfo.put("VmNonHeap", memBean.getNonHeapMemoryUsage().getUsed() / 0x100000L);
        return jvmInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Memory)) {
            return false;
        }
        Memory memory = (Memory)o;
        return Objects.equals(this.getTotal(), memory.getTotal()) && Objects.equals(this.getFree(), memory.getFree()) && Objects.equals(this.getBuffers(), memory.getBuffers()) && Objects.equals(this.getCached(), memory.getCached()) && Objects.equals(this.getFreeTotal(), memory.getFreeTotal()) && Objects.equals(this.getVmFree(), memory.getVmFree()) && Objects.equals(this.getVmMax(), memory.getVmMax()) && Objects.equals(this.getVmTotal(), memory.getVmTotal()) && Objects.equals(this.getVmHeap(), memory.getVmHeap()) && Objects.equals(this.getVmNonheap(), memory.getVmNonheap());
    }

    public int hashCode() {
        return Objects.hash(this.getTotal(), this.getFree(), this.getBuffers(), this.getCached(), this.getFreeTotal(), this.getVmFree(), this.getVmMax(), this.getVmTotal(), this.getVmHeap(), this.getVmNonheap());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Memory{");
        sb.append("total=").append(this.getTotal());
        sb.append(", free=").append(this.getFree());
        sb.append(", buffers=").append(this.getBuffers());
        sb.append(", cached=").append(this.getCached());
        sb.append(", free_total=").append(this.getFreeTotal());
        sb.append(", vm_free=").append(this.getVmFree());
        sb.append(", vm_max=").append(this.getVmMax());
        sb.append(", vm_total=").append(this.getVmTotal());
        sb.append(", vm_heap=").append(this.getVmHeap());
        sb.append(", vm_nonheap=").append(this.getVmNonheap());
        sb.append('}');
        return sb.toString();
    }

    public Number getTotal() {
        return this.total;
    }

    public Number getFree() {
        return this.free;
    }

    public Number getBuffers() {
        return this.buffers;
    }

    public Number getCached() {
        return this.cached;
    }

    public Number getFreeTotal() {
        return this.freeTotal;
    }

    public Number getVmFree() {
        return this.vmFree;
    }

    public Number getVmMax() {
        return this.vmMax;
    }

    public Number getVmTotal() {
        return this.vmTotal;
    }

    public Number getVmHeap() {
        return this.vmHeap;
    }

    public Number getVmNonheap() {
        return this.vmNonheap;
    }
}

