/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Stats;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"environment_name", "hostname", "project_root", "pid", "time", "stats", ""})
public class ServerDetails
implements Serializable {
    private static final long serialVersionUID = 4689643321013504425L;
    private static Logger logger = LoggerFactory.getLogger(ServerDetails.class);
    @JsonProperty(value="environment_name")
    private final String environmentName;
    private final String hostname;
    @JsonProperty(value="project_root")
    private final String projectRoot;
    private final Integer pid;
    private final String time;
    private final Stats stats;

    public ServerDetails(ConfigContext context) {
        this.environmentName = context.getEnvironment();
        this.hostname = ServerDetails.hostname();
        this.projectRoot = ServerDetails.projectRoot();
        this.pid = ServerDetails.pid();
        this.time = ServerDetails.time();
        this.stats = new Stats();
    }

    @JsonCreator
    public ServerDetails(@JsonProperty(value="environment_name") String environmentName, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="project_root") String projectRoot, @JsonProperty(value="pid") Integer pid, @JsonProperty(value="time") String time, @JsonProperty(value="stats") Stats stats) {
        this.environmentName = environmentName;
        this.hostname = hostname;
        this.projectRoot = projectRoot;
        this.pid = pid;
        this.time = time;
        this.stats = stats;
    }

    protected static String hostname() {
        String host;
        if (System.getenv("HOSTNAME") != null) {
            host = System.getenv("HOSTNAME");
        } else if (System.getenv("COMPUTERNAME") != null) {
            host = System.getenv("COMPUTERNAME");
        } else {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.error("Unable to find hostname", (Throwable)e);
                host = "unknown";
            }
        }
        return host;
    }

    protected static String projectRoot() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Can't get runtime root path", (Throwable)e);
            return "unknown";
        }
    }

    protected static Integer pid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return null;
        }
        try {
            return Integer.parseInt(jvmName.substring(0, index));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String time() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        formatter.setTimeZone(tz);
        return formatter.format(new Date());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerDetails that = (ServerDetails)o;
        return Objects.equals(this.getEnvironmentName(), that.getEnvironmentName()) && Objects.equals(this.getHostname(), that.getHostname()) && Objects.equals(this.getProjectRoot(), that.getProjectRoot()) && Objects.equals(this.getPid(), that.getPid()) && Objects.equals(this.getTime(), that.getTime()) && Objects.equals(this.getStats(), that.getStats());
    }

    public int hashCode() {
        return Objects.hash(this.getEnvironmentName(), this.getHostname(), this.getProjectRoot(), this.getPid(), this.getTime(), this.getStats());
    }

    public String toString() {
        return "ServerDetails{environment_name='" + this.getEnvironmentName() + '\'' + ", hostname='" + this.getHostname() + '\'' + ", project_root='" + this.getProjectRoot() + '\'' + ", pid=" + this.getPid() + ", stats=" + this.getStats() + '}';
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public Integer getPid() {
        return this.pid;
    }

    public String getTime() {
        return this.time;
    }

    public Stats getStats() {
        return this.stats;
    }
}

