/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.jcabi.manifests.Manifests;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Notifier
implements Serializable {
    public static final String VERSION = Notifier.findVersion();
    private static final long serialVersionUID = -9160493241433298708L;
    private final String name = "io.honeybadger:honeybadger-java";
    private final String url = "https://github.com/honeybadger-io/honeybadger-java";
    private final String version = VERSION;

    public String getName() {
        return "io.honeybadger:honeybadger-java";
    }

    public String getUrl() {
        return "https://github.com/honeybadger-io/honeybadger-java";
    }

    public String getVersion() {
        return this.version;
    }

    private static String findVersion() {
        String sysPropVersion = System.getProperty("honeybadger.version");
        if (sysPropVersion != null && !sysPropVersion.isEmpty()) {
            return sysPropVersion;
        }
        try {
            String manifestVersion = Manifests.read((String)"Honeybadger-Java-Version");
            if (manifestVersion != null && !manifestVersion.isEmpty()) {
                return manifestVersion;
            }
            return "unknown";
        }
        catch (IllegalArgumentException e) {
            return "unknown";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notifier notifier = (Notifier)o;
        return Objects.equals("io.honeybadger:honeybadger-java", notifier.name) && Objects.equals("https://github.com/honeybadger-io/honeybadger-java", notifier.url) && Objects.equals(this.version, notifier.version);
    }

    public int hashCode() {
        return Objects.hash("io.honeybadger:honeybadger-java", "https://github.com/honeybadger-io/honeybadger-java", this.version);
    }
}

