/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Cause;
import java.io.Serializable;
import java.util.LinkedList;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Causes
extends LinkedList<Cause>
implements Serializable {
    private static final long serialVersionUID = -5359764114506595006L;
    private static final int MAX_CAUSES = 100;

    public Causes(ConfigContext config, Throwable rootError) {
        if (rootError == null) {
            throw new IllegalArgumentException("Error can't be null");
        }
        this.addCauses(config, rootError);
    }

    void addCauses(ConfigContext config, Throwable rootError) {
        if (rootError.getCause() == null) {
            return;
        }
        Object lastCause = null;
        Throwable nextCause = rootError.getCause();
        int iterations = 0;
        while (lastCause == null || !lastCause.equals(nextCause)) {
            this.addFirst(new Cause(config, nextCause));
            if (++iterations > 100) break;
            lastCause = nextCause;
            if (null != (nextCause = nextCause.getCause())) continue;
        }
    }
}

