/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.honeybadger.reporter.config.ConfigContext;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BacktraceElement
implements Serializable {
    private static final long serialVersionUID = -4455225669072193184L;
    @JacksonInject(value="config")
    private final ConfigContext config;
    private final String file;
    private final String method;
    private final String number;
    private final String context;

    public String getFile() {
        return this.file;
    }

    public String getMethod() {
        return this.method;
    }

    public String getNumber() {
        return this.number;
    }

    public String getContext() {
        return this.context;
    }

    @JsonCreator
    public BacktraceElement(@JacksonInject(value="config") ConfigContext config, @JsonProperty(value="number") String number, @JsonProperty(value="file") String file, @JsonProperty(value="method") String method) {
        this.config = config;
        this.number = number;
        this.file = file;
        this.method = method;
        this.context = this.calculateContext(method).getName();
    }

    public BacktraceElement(ConfigContext config, StackTraceElement element) {
        this.config = config;
        this.number = String.valueOf(element.getLineNumber());
        this.file = String.valueOf(element.getFileName());
        this.method = BacktraceElement.formatMethod(element);
        this.context = this.calculateContext(this.method).getName();
    }

    static String formatMethod(StackTraceElement element) {
        return String.format("%s.%s", element.getClassName(), element.getMethodName());
    }

    Context calculateContext(String methodName) {
        String appPackage = this.config.getApplicationPackage();
        Context methodContext = appPackage == null || appPackage.isEmpty() ? Context.ALL : (methodName == null || methodName.isEmpty() ? Context.ALL : (methodName.startsWith(appPackage) ? Context.APP : Context.ALL));
        return methodContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BacktraceElement that = (BacktraceElement)o;
        return Objects.equals(this.config, that.config) && Objects.equals(this.file, that.file) && Objects.equals(this.method, that.method) && Objects.equals(this.number, that.number) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.file, this.method, this.number, this.context);
    }

    static enum Context {
        ALL("all"),
        APP("app");

        private final String name;

        private Context(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

