/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Backtrace;
import io.honeybadger.reporter.dto.Causes;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"class", "message", "tags", "backtrace", "causes"})
public class NoticeDetails
implements Serializable {
    private static final long serialVersionUID = -3055963787038629496L;
    @JsonProperty(value="class")
    private final String className;
    private final String message;
    private final Set<String> tags;
    private final Backtrace backtrace;
    private final Causes causes;

    public NoticeDetails(ConfigContext config, Throwable error) {
        this(config, error, Collections.emptySet());
    }

    public NoticeDetails(ConfigContext config, Throwable error, Set<String> tags) {
        this(config, error, tags, error.getMessage());
    }

    public NoticeDetails(ConfigContext config, Throwable error, Set<String> tags, String message) {
        if (error == null) {
            throw new IllegalArgumentException("Error can't be null");
        }
        this.className = error.getClass().getName();
        this.message = message;
        this.tags = tags;
        this.backtrace = new Backtrace(config, error);
        this.causes = new Causes(config, error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoticeDetails that = (NoticeDetails)o;
        return Objects.equals(this.getClassName(), that.getClassName()) && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getTags(), that.getTags()) && Objects.equals(this.getBacktrace(), that.getBacktrace()) && Objects.equals(this.getCauses(), that.getCauses());
    }

    public int hashCode() {
        return Objects.hash(this.getClassName(), this.getMessage(), this.getTags(), this.getBacktrace(), this.getCauses());
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Backtrace getBacktrace() {
        return this.backtrace;
    }

    public Causes getCauses() {
        return this.causes;
    }
}

