/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.servlet;

import io.honeybadger.org.apache.http.entity.ContentType;
import io.honeybadger.reporter.FeedbackForm;
import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.config.ServletFilterConfigContext;
import io.honeybadger.reporter.config.SystemSettingsConfigContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HoneybadgerFilter
implements Filter {
    private ConfigContext config;
    private NoticeReporter reporter;
    private FeedbackForm feedbackForm;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletFilterConfigContext filterContext = new ServletFilterConfigContext(filterConfig);
        SystemSettingsConfigContext config = new SystemSettingsConfigContext(filterContext);
        this.config = config;
        this.reporter = new HoneybadgerReporter(config);
        this.feedbackForm = new FeedbackForm(config);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable e) {
            HttpServletRequest httpServletRequest;
            NoticeReportResult result = this.reporter.reportError(e, request);
            if (this.config.isFeedbackFormDisplayed() != null && !this.config.isFeedbackFormDisplayed().booleanValue()) {
                throw e;
            }
            response.reset();
            if (request instanceof HttpServletRequest && this.acceptsOnlyJson(httpServletRequest = (HttpServletRequest)request)) {
                this.jsonError(result.getId(), response);
                return;
            }
            response.setContentType(ContentType.TEXT_HTML.getMimeType());
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                httpServletResponse.setStatus(500);
            }
            UUID errorId = result == null ? null : result.getId();
            this.feedbackForm.renderHtml(errorId, e.getMessage(), response.getWriter(), request.getLocale());
        }
    }

    protected boolean acceptsOnlyJson(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaders("Accept");
        if (enumeration == null) {
            return false;
        }
        if (!enumeration.hasMoreElements()) {
            return false;
        }
        ArrayList accepts = Collections.list(enumeration);
        if (accepts.size() == 1) {
            return ((String)accepts.get(0)).equals(ContentType.APPLICATION_JSON.getMimeType());
        }
        return false;
    }

    protected void jsonError(UUID errorId, ServletResponse response) throws IOException {
        String json = String.format("{ error_id : \"%s\" }", errorId);
        response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        response.getWriter().append(json);
    }

    public void destroy() {
    }

    NoticeReporter getReporter() {
        return this.reporter;
    }

    void setReporter(NoticeReporter reporter) {
        this.reporter = reporter;
    }

    public void setFeedbackForm(FeedbackForm feedbackForm) {
        this.feedbackForm = feedbackForm;
    }

    ConfigContext getConfig() {
        return this.config;
    }
}

