/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.reporter.config.ConfigContext;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;

public class Details
extends LinkedHashMap<String, LinkedHashMap<String, String>>
implements Serializable {
    private static final long serialVersionUID = -6238693264237448645L;
    private final ConfigContext config;

    public Details(ConfigContext config) {
        this.config = config;
    }

    public Details() {
        ConfigContext config = ConfigContext.threadLocal.get();
        if (config == null) {
            throw new NullPointerException("Unable to get the expected ConfigContext from ThreadLocal");
        }
        this.config = config;
    }

    void addDefaultDetails() {
        this.put("System Properties", this.systemProperties());
        this.put("MDC Properties", Details.mdcProperties());
    }

    protected static LinkedHashMap<String, String> mdcProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map mdc = MDC.getCopyOfContextMap();
        if (mdc != null) {
            for (Map.Entry entry : mdc.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return map;
    }

    protected LinkedHashMap<String, String> systemProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set<String> excludedSysProps = this.config.getExcludedSysProps();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (excludedSysProps.contains(entry.getKey().toString())) continue;
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }
}

