/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter;

import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.config.SystemSettingsConfigContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoneybadgerUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    protected ConfigContext config;
    protected NoticeReporter reporter;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public HoneybadgerUncaughtExceptionHandler() {
        this(new SystemSettingsConfigContext());
    }

    public HoneybadgerUncaughtExceptionHandler(ConfigContext config) {
        this.config = config;
        this.reporter = new HoneybadgerReporter(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        NoticeReportResult errorResult = null;
        try {
            errorResult = this.reporter.reportError(e);
        }
        catch (RuntimeException re) {
            block7: {
                try {
                    if (!this.logger.isErrorEnabled()) break block7;
                    this.logger.error("An error occurred when sending data to the Honeybadger API", (Throwable)re);
                }
                catch (Throwable throwable) {
                    if (this.logger.isErrorEnabled()) {
                        String msg = "An unhandled exception has occurred [%s]";
                        String id = errorResult == null ? "no-id" : errorResult.getId().toString();
                        this.logger.error(String.format(msg, id), e);
                    }
                    throw throwable;
                }
            }
            if (this.logger.isErrorEnabled()) {
                String msg = "An unhandled exception has occurred [%s]";
                String id = errorResult == null ? "no-id" : errorResult.getId().toString();
                this.logger.error(String.format(msg, id), e);
            }
        }
        if (this.logger.isErrorEnabled()) {
            String msg = "An unhandled exception has occurred [%s]";
            String id = errorResult == null ? "no-id" : errorResult.getId().toString();
            this.logger.error(String.format(msg, id), e);
        }
    }

    public static void registerAsUncaughtExceptionHandler() {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public static void registerAsUncaughtExceptionHandler(ConfigContext configContext) {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler(configContext);
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public static void registerAsUncaughtExceptionHandler(Thread t) {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
    }

    public static void registerAsUncaughtExceptionHandler(ConfigContext configContext, Thread t) {
        HoneybadgerUncaughtExceptionHandler handler = new HoneybadgerUncaughtExceptionHandler(configContext);
        t.setUncaughtExceptionHandler(handler);
    }
}

