/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter;

import io.honeybadger.com.github.mustachejava.DefaultMustacheFactory;
import io.honeybadger.com.github.mustachejava.Mustache;
import io.honeybadger.com.github.mustachejava.MustacheFactory;
import io.honeybadger.reporter.config.ConfigContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class FeedbackForm {
    private final ConfigContext config;
    protected final MustacheFactory mf = new DefaultMustacheFactory();
    protected final Locale defaultLocale = new Locale("en", "US");
    protected final Mustache mustache;
    protected final String actionURI;

    public FeedbackForm(ConfigContext config) {
        String templatePath = config.getFeedbackFormPath();
        if (templatePath == null) {
            throw new IllegalArgumentException("template path must not be null");
        }
        this.config = config;
        this.mustache = this.mf.compile(templatePath);
        this.actionURI = this.actionURI();
    }

    protected String actionURI() {
        return String.format("%s/%s", this.config.getHoneybadgerUrl(), "v1/feedback/");
    }

    public void renderHtml(Object errorId, String message, Writer writer) throws IOException {
        this.renderHtml(errorId, message, writer, this.defaultLocale);
    }

    public void renderHtml(Object errorId, String message, Writer writer, Locale locale) throws IOException {
        Locale selectedLocale = locale == null ? this.defaultLocale : locale;
        ResourceBundle messages = ResourceBundle.getBundle("i8n/feedback-form", selectedLocale);
        HashMap<String, String> scopes = new HashMap<String, String>(30);
        if (errorId == null) {
            String msg = "<!DOCTYPE HTML>\n<html>\n<head><title>Error</title></head><body><h1>An unknown error occurred</h1><body></html>";
            writer.append(msg);
            return;
        }
        scopes.put("error_id", errorId.toString());
        if (message != null && !message.isEmpty()) {
            scopes.put("error_msg", message);
        }
        scopes.put("action", this.actionURI);
        Enumeration<String> enumeration = messages.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            scopes.put(key, messages.getString(key));
        }
        this.mustache.execute(writer, scopes);
    }
}

