/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.play;

import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import javax.inject.Inject;
import javax.inject.Provider;
import play.Configuration;
import play.Environment;
import play.Logger;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.HttpErrorHandlerExceptions;
import play.api.routing.Router;
import play.http.DefaultHttpErrorHandler;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import scala.Option;

public class HoneybadgerErrorHandler
extends DefaultHttpErrorHandler {
    NoticeReporter reporter = new HoneybadgerReporter();
    protected final Environment environment;
    protected final OptionalSourceMapper sourceMapper;

    @Inject
    public HoneybadgerErrorHandler(Configuration configuration, Environment environment, OptionalSourceMapper sourceMapper, Provider<Router> routes) {
        super(configuration, environment, sourceMapper, routes);
        this.environment = environment;
        this.sourceMapper = sourceMapper;
        System.setProperty("ENV", environment.mode().name());
    }

    public F.Promise<Result> onServerError(Http.RequestHeader request, Throwable exception) {
        NoticeReportResult errorResult = this.reporter.reportError(exception, request);
        try {
            UsefulException usefulException = this.throwableToUsefulException(exception);
            String honeybadgerErrorId = errorResult != null && errorResult.getId() != null ? errorResult.getId().toString() : String.format("play-error-%s", usefulException.id);
            usefulException.id = honeybadgerErrorId;
            this.logServerError(request, usefulException);
            switch (this.environment.mode()) {
                case PROD: {
                    return this.onProdServerError(request, usefulException);
                }
            }
            return this.onDevServerError(request, usefulException);
        }
        catch (Exception e) {
            Logger.error((String)"Error while handling error", (Throwable)e);
            return F.Promise.pure((Object)Results.internalServerError());
        }
    }

    protected UsefulException throwableToUsefulException(Throwable throwable) {
        return HttpErrorHandlerExceptions.throwableToUsefulException((Option)this.sourceMapper.sourceMapper(), (boolean)this.environment.isProd(), (Throwable)throwable);
    }
}

