/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class Params
extends LinkedHashMap<String, String>
implements Serializable {
    private static final long serialVersionUID = -5633548926144410598L;
    private final Set<String> excludedValues = Params.buildExcludedProps();

    protected static Set<String> buildExcludedProps() {
        String excluded = System.getProperty("honeybadger.excluded_params");
        HashSet<String> set = new HashSet<String>();
        if (excluded == null || excluded.isEmpty()) {
            return set;
        }
        Collections.addAll(set, excluded.split(","));
        return set;
    }

    static String csv(String[] strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            builder.append(strings[i]);
            if (i >= strings.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public String put(String key, String value) {
        if (this.excludedValues.contains(key)) {
            return null;
        }
        return super.put(key, value);
    }
}

