/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.com.google.gson.annotations.SerializedName;
import io.honeybadger.reporter.dto.Backtrace;
import io.honeybadger.reporter.dto.Causes;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class NoticeDetails
implements Serializable {
    private static final long serialVersionUID = -3055963787038629496L;
    @SerializedName(value="class")
    public final String className;
    public final String message;
    public final Set<String> tags;
    public final Backtrace backtrace;
    public final Causes causes;

    public NoticeDetails(Throwable error) {
        this(error, Collections.EMPTY_SET);
    }

    public NoticeDetails(Throwable error, Set<String> tags) {
        if (error == null) {
            throw new IllegalArgumentException("Error can't be null");
        }
        this.className = error.getClass().getName();
        this.message = error.getMessage();
        this.tags = tags;
        this.backtrace = new Backtrace(error);
        this.causes = new Causes(error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoticeDetails that = (NoticeDetails)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.backtrace != null ? !this.backtrace.equals(that.backtrace) : that.backtrace != null) {
            return false;
        }
        return !(this.causes == null ? that.causes != null : !this.causes.equals(that.causes));
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.backtrace != null ? this.backtrace.hashCode() : 0);
        result = 31 * result + (this.causes != null ? this.causes.hashCode() : 0);
        return result;
    }
}

