/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter;

import io.honeybadger.com.google.gson.Gson;
import io.honeybadger.com.google.gson.GsonBuilder;
import io.honeybadger.org.apache.http.HttpHost;
import io.honeybadger.org.apache.http.HttpResponse;
import io.honeybadger.org.apache.http.HttpVersion;
import io.honeybadger.org.apache.http.client.fluent.Response;
import io.honeybadger.org.apache.http.entity.ContentType;
import io.honeybadger.reporter.HoneybadgerException;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import io.honeybadger.reporter.dto.HttpServletRequestFactory;
import io.honeybadger.reporter.dto.Notice;
import io.honeybadger.reporter.dto.NoticeDetails;
import io.honeybadger.reporter.dto.PlayHttpRequestFactory;
import io.honeybadger.reporter.dto.Request;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Http;

public class HoneybadgerReporter
implements NoticeReporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> excludedExceptionClasses;
    private final Gson gson = new GsonBuilder().create();

    public HoneybadgerReporter() {
        this.excludedExceptionClasses = this.buildExcludedExceptionClasses();
    }

    @Override
    public NoticeReportResult reportError(Throwable error) {
        return this.submitError(error, null);
    }

    @Override
    public NoticeReportResult reportError(Throwable error, Object request) {
        Request requestDetails;
        if (error == null) {
            return null;
        }
        if (request == null) {
            return this.submitError(error, null);
        }
        if (request instanceof Request) {
            this.logger.debug("Reporting using a request DTO");
            requestDetails = (Request)request;
        } else if (this.supportsHttpServletRequest() && request instanceof HttpServletRequest) {
            this.logger.debug("Reporting from a servlet context");
            requestDetails = HttpServletRequestFactory.create((HttpServletRequest)request);
        } else if (this.supportsPlayHttpRequest() && request instanceof Http.Request) {
            this.logger.debug("Reporting from the Play Framework");
            requestDetails = PlayHttpRequestFactory.create((Http.Request)request);
        } else {
            this.logger.debug("No request object available");
            requestDetails = null;
        }
        return this.submitError(error, requestDetails);
    }

    protected boolean supportsHttpServletRequest() {
        try {
            Class.forName("javax.servlet.http.HttpServletRequest");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected boolean supportsPlayHttpRequest() {
        try {
            Class.forName("play.mvc.Http", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected NoticeReportResult submitError(Throwable error, Request request) {
        String errorClassName = error.getClass().getName();
        if (errorClassName != null && this.excludedExceptionClasses.contains(errorClassName)) {
            return null;
        }
        Notice notice = new Notice().setError(new NoticeDetails(error));
        if (request != null) {
            notice.setRequest(request);
        }
        for (int retries = 0; retries < 3; ++retries) {
            try {
                String json = this.gson.toJson(notice);
                HttpResponse response = this.sendToHoneybadger(json).returnResponse();
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == 201) {
                    this.logger.debug("Honeybadger logged error correctly: [{}]", (Object)error.getMessage());
                    UUID id = this.parseErrorId(response, this.gson);
                    return new NoticeReportResult(id, notice, error);
                }
                this.logger.error("Honeybadger did not respond with the correct code. Response was [{}]. Retries={}", (Object)responseCode, (Object)retries);
                continue;
            }
            catch (IOException e) {
                String msg = String.format("There was an error when trying to send the error to Honeybadger. Retries=%d", retries);
                this.logger.error(msg, (Throwable)e);
                this.logger.error("Original Error", error);
                return null;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private UUID parseErrorId(HttpResponse response, Gson gson) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<String> buildExcludedExceptionClasses() {
        String excluded = System.getProperty("honeybadger.excluded_exception_classes");
        HashSet<String> set = new HashSet<String>();
        if (excluded == null || excluded.isEmpty()) {
            return set;
        }
        Collections.addAll(set, excluded.split(","));
        return set;
    }

    private Response sendToHoneybadger(String jsonError) throws IOException {
        URI honeybadgerUrl = URI.create(String.format("%s/%s", HoneybadgerReporter.honeybadgerUrl(), "v1/notices"));
        io.honeybadger.org.apache.http.client.fluent.Request request = this.buildRequest(honeybadgerUrl, jsonError);
        return request.execute();
    }

    private io.honeybadger.org.apache.http.client.fluent.Request buildRequest(URI honeybadgerUrl, String jsonError) {
        io.honeybadger.org.apache.http.client.fluent.Request request = io.honeybadger.org.apache.http.client.fluent.Request.Post(honeybadgerUrl).addHeader("X-API-Key", this.apiKey()).addHeader("Accept", "application/json").version(HttpVersion.HTTP_1_1).bodyString(jsonError, ContentType.APPLICATION_JSON);
        if (System.getProperty("http.proxyHost") != null && !System.getProperty("http.proxyHost").isEmpty()) {
            int port = Integer.parseInt(System.getProperty("http.proxyPort"));
            HttpHost proxy = new HttpHost(System.getProperty("http.proxyHost"), port);
            request.viaProxy(proxy);
        }
        return request;
    }

    public static URI honeybadgerUrl() {
        try {
            String sysProp = System.getProperty("honeybadger.url");
            String url = sysProp != null && !sysProp.isEmpty() ? sysProp : String.format("%s://%s", "https", "api.honeybadger.io");
            return URI.create(url);
        }
        catch (IllegalArgumentException e) {
            String format = "Honeybadger URL was not correctly formed. Double check the [%s] system property and verify that it is a valid URL.";
            String msg = String.format(format, "honeybadger.url");
            throw new HoneybadgerException(msg, e);
        }
    }

    private String apiKey() {
        String envKey = System.getenv("HONEYBADGER_API_KEY");
        if (envKey != null && !envKey.isEmpty()) {
            return envKey;
        }
        return System.getProperty("honeybadger.api_key");
    }
}

