/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.loader;

import io.honeybadger.com.google.gson.Gson;
import io.honeybadger.com.google.gson.GsonBuilder;
import io.honeybadger.com.google.gson.JsonElement;
import io.honeybadger.com.google.gson.JsonObject;
import io.honeybadger.org.apache.http.client.fluent.Request;
import io.honeybadger.org.apache.http.client.fluent.Response;
import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.dto.Notice;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoneybadgerNoticeLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Gson gson = new GsonBuilder().create();

    String pullFaultJson(UUID faultId) throws IOException {
        String readApiKey = HoneybadgerNoticeLoader.readApiKey();
        if (readApiKey == null || readApiKey.isEmpty()) {
            String msg = String.format("Property %s must be set if you are going to be accessing the Read API", "honeybadger.read_api_key");
            throw new IllegalArgumentException(msg);
        }
        URI baseURI = URI.create(String.format("%s/%s/%s", HoneybadgerReporter.honeybadgerUrl(), "v1/notices", faultId));
        String withAuth = String.format("%s/?auth_token=%s", baseURI, readApiKey);
        this.logger.debug("Querying for error details: {}", (Object)baseURI);
        Response response = Request.Get(withAuth).addHeader("Accept", "application/json").execute();
        return response.returnContent().asString();
    }

    private static String readApiKey() {
        String envKey = System.getenv("HONEYBADGER_READ_API_KEY");
        if (envKey != null && !envKey.isEmpty()) {
            return envKey;
        }
        return System.getProperty("honeybadger.read_api_key");
    }

    public Notice findErrorDetails(UUID faultId) throws IOException {
        String json = this.pullFaultJson(faultId);
        JsonObject originalJson = this.gson.fromJson(json, JsonObject.class).getAsJsonObject();
        JsonObject cgiData = originalJson.get("web_environment").getAsJsonObject();
        originalJson.get("request").getAsJsonObject().add("cgi_data", cgiData);
        Notice error = this.gson.fromJson((JsonElement)originalJson, Notice.class);
        return error;
    }
}

