/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formattable;
import java.util.Formatter;

final class ExceptionDecor
implements Formattable {
    private final transient Throwable throwable;

    ExceptionDecor(Throwable thr) {
        this.throwable = thr;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String text;
        if (this.throwable == null) {
            text = "NULL";
        } else if ((flags & 4) == 0) {
            StringWriter writer = new StringWriter();
            this.throwable.printStackTrace(new PrintWriter(writer));
            text = writer.toString();
        } else {
            text = this.throwable.getMessage();
        }
        formatter.format("%s", text);
    }

    public String toString() {
        return "ExceptionDecor(throwable=" + this.throwable + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionDecor)) {
            return false;
        }
        ExceptionDecor other = (ExceptionDecor)o;
        Throwable this$throwable = this.throwable;
        Throwable other$throwable = other.throwable;
        return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Throwable $throwable = this.throwable;
        result = result * 59 + ($throwable == null ? 0 : $throwable.hashCode());
        return result;
    }
}

