/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.util.HBStringUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.LoggerFactory;

public class Memory
implements Serializable {
    private static final long serialVersionUID = -8799953046383217102L;
    private static final String LINUX_MEMINFO_PATH = "/proc/meminfo";
    public final Number total;
    public final Number free;
    public final Number buffers;
    public final Number cached;
    public final Number free_total;
    public final Number vm_free;
    public final Number vm_max;
    public final Number vm_total;
    public final Number vm_heap;
    public final Number vm_nonheap;

    public Memory() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String os = osBean.getName();
        HashMap memValues = os.equals("Linux") ? Memory.findLinuxMemInfo(new File(LINUX_MEMINFO_PATH)) : new HashMap();
        Map<String, Number> vmMemValues = Memory.findJvmMemInfo();
        this.total = (Number)memValues.get("MemTotal");
        this.free = (Number)memValues.get("MemFree");
        this.buffers = (Number)memValues.get("Buffers");
        this.cached = (Number)memValues.get("Cached");
        this.free_total = (Number)memValues.get("FreeTotal");
        this.vm_free = vmMemValues.get("VmFreeMem");
        this.vm_max = vmMemValues.get("VmMaxMem");
        this.vm_total = vmMemValues.get("VmTotalMem");
        this.vm_heap = vmMemValues.get("VmHeap");
        this.vm_nonheap = vmMemValues.get("VmNonHeap");
    }

    public Memory(Number total, Number free, Number buffers, Number cached, Number free_total, Number vm_free, Number vm_max, Number vm_total, Number vm_heap, Number vm_nonheap) {
        this.total = total;
        this.free = free;
        this.buffers = buffers;
        this.cached = cached;
        this.free_total = free_total;
        this.vm_free = vm_free;
        this.vm_max = vm_max;
        this.vm_total = vm_total;
        this.vm_heap = vm_heap;
        this.vm_nonheap = vm_nonheap;
    }

    static Map<String, Long> findLinuxMemInfo(File memInfoFile) {
        HashMap<String, Long> memInfo = new HashMap<String, Long>(50);
        long mebibyteMultiplier = 1024L;
        if (memInfoFile.exists() && memInfoFile.isFile() && memInfoFile.canRead()) {
            try (Scanner scanner = new Scanner(memInfoFile);){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    String[] fields = line.split("(:?)\\s+", 3);
                    String name = fields[0];
                    String kbValue = fields[1];
                    Long mbValue = Long.parseLong(kbValue) / 1024L;
                    if (!HBStringUtils.isPresent(name) || !HBStringUtils.isPresent(kbValue)) continue;
                    memInfo.put(name, mbValue);
                }
                long free = memInfo.containsKey("MemFree") ? memInfo.get("MemFree") : 0L;
                long buffers = memInfo.containsKey("Buffers") ? memInfo.get("Buffers") : 0L;
                long cached = memInfo.containsKey("Cached") ? memInfo.get("Cached") : 0L;
                long freeTotal = free + buffers + cached;
                memInfo.put("FreeTotal", freeTotal);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Memory.class).error("Error reading memory information", (Throwable)e);
            }
        } else {
            LoggerFactory.getLogger(Memory.class).warn("Error reading memory information from {}", (Object)memInfoFile);
        }
        return memInfo;
    }

    static Map<String, Number> findJvmMemInfo() {
        HashMap<String, Number> jvmInfo = new HashMap<String, Number>(10);
        Runtime runtime = Runtime.getRuntime();
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        long mebibyte = 0x100000L;
        jvmInfo.put("VmFreeMem", runtime.freeMemory() / 0x100000L);
        jvmInfo.put("VmMaxMem", runtime.maxMemory() / 0x100000L);
        jvmInfo.put("VmTotalMem", runtime.totalMemory() / 0x100000L);
        jvmInfo.put("VmHeap", memBean.getHeapMemoryUsage().getUsed() / 0x100000L);
        jvmInfo.put("VmNonHeap", memBean.getNonHeapMemoryUsage().getUsed() / 0x100000L);
        return jvmInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Memory memory = (Memory)o;
        if (this.total != null ? !this.total.equals(memory.total) : memory.total != null) {
            return false;
        }
        if (this.free != null ? !this.free.equals(memory.free) : memory.free != null) {
            return false;
        }
        if (this.buffers != null ? !this.buffers.equals(memory.buffers) : memory.buffers != null) {
            return false;
        }
        if (this.cached != null ? !this.cached.equals(memory.cached) : memory.cached != null) {
            return false;
        }
        if (this.free_total != null ? !this.free_total.equals(memory.free_total) : memory.free_total != null) {
            return false;
        }
        if (this.vm_free != null ? !this.vm_free.equals(memory.vm_free) : memory.vm_free != null) {
            return false;
        }
        if (this.vm_max != null ? !this.vm_max.equals(memory.vm_max) : memory.vm_max != null) {
            return false;
        }
        if (this.vm_total != null ? !this.vm_total.equals(memory.vm_total) : memory.vm_total != null) {
            return false;
        }
        if (this.vm_heap != null ? !this.vm_heap.equals(memory.vm_heap) : memory.vm_heap != null) {
            return false;
        }
        return !(this.vm_nonheap == null ? memory.vm_nonheap != null : !this.vm_nonheap.equals(memory.vm_nonheap));
    }

    public int hashCode() {
        int result = this.total != null ? this.total.hashCode() : 0;
        result = 31 * result + (this.free != null ? this.free.hashCode() : 0);
        result = 31 * result + (this.buffers != null ? this.buffers.hashCode() : 0);
        result = 31 * result + (this.cached != null ? this.cached.hashCode() : 0);
        result = 31 * result + (this.free_total != null ? this.free_total.hashCode() : 0);
        result = 31 * result + (this.vm_free != null ? this.vm_free.hashCode() : 0);
        result = 31 * result + (this.vm_max != null ? this.vm_max.hashCode() : 0);
        result = 31 * result + (this.vm_total != null ? this.vm_total.hashCode() : 0);
        result = 31 * result + (this.vm_heap != null ? this.vm_heap.hashCode() : 0);
        result = 31 * result + (this.vm_nonheap != null ? this.vm_nonheap.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Memory{");
        sb.append("total=").append(this.total);
        sb.append(", free=").append(this.free);
        sb.append(", buffers=").append(this.buffers);
        sb.append(", cached=").append(this.cached);
        sb.append(", free_total=").append(this.free_total);
        sb.append(", vm_free=").append(this.vm_free);
        sb.append(", vm_max=").append(this.vm_max);
        sb.append(", vm_total=").append(this.vm_total);
        sb.append(", vm_heap=").append(this.vm_heap);
        sb.append(", vm_nonheap=").append(this.vm_nonheap);
        sb.append('}');
        return sb.toString();
    }
}

