/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Scanner;
import org.slf4j.LoggerFactory;

public class Load
implements Serializable {
    private static final long serialVersionUID = 3398000045209329774L;
    public final Number one;
    public final Number five;
    public final Number fifteen;

    public Load() {
        Number[] loadAverages = Load.findLoadAverages();
        this.one = loadAverages[0];
        this.five = loadAverages[1];
        this.fifteen = loadAverages[2];
    }

    public Load(Number one, Number five, Number fifteen) {
        this.one = one;
        this.five = five;
        this.fifteen = fifteen;
    }

    static Number[] findLoadAverages() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String os = osBean.getName();
        if (os.equals("Linux")) {
            return Load.findLinuxLoadAverages(osBean);
        }
        return Load.defaultLoadAverages(osBean);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Number[] findLinuxLoadAverages(OperatingSystemMXBean osBean) {
        File loadavg = new File("/proc/loadavg");
        if (loadavg.exists() && loadavg.isFile() && loadavg.canRead()) {
            try (Scanner scanner = new Scanner(loadavg);){
                if (!scanner.hasNext()) {
                    Number[] numberArray2 = Load.defaultLoadAverages(osBean);
                    return numberArray2;
                }
                String line = scanner.nextLine();
                String[] values = line.split(" ", 4);
                Number[] numberArray = new Number[]{Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2])};
                return numberArray;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Load.class).debug("Error reading /proc/loadavg", (Throwable)e);
                return Load.defaultLoadAverages(osBean);
            }
        }
        LoggerFactory.getLogger(Load.class).debug("Couldn't fid or access /proc/loadavg");
        return Load.defaultLoadAverages(osBean);
    }

    static Number[] defaultLoadAverages(OperatingSystemMXBean osBean) {
        return new Number[]{osBean.getSystemLoadAverage(), null, null};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Load load = (Load)o;
        if (this.one != null ? !this.one.equals(load.one) : load.one != null) {
            return false;
        }
        if (this.five != null ? !this.five.equals(load.five) : load.five != null) {
            return false;
        }
        return !(this.fifteen == null ? load.fifteen != null : !this.fifteen.equals(load.fifteen));
    }

    public int hashCode() {
        int result = this.one != null ? this.one.hashCode() : 0;
        result = 31 * result + (this.five != null ? this.five.hashCode() : 0);
        result = 31 * result + (this.fifteen != null ? this.fifteen.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Load{one=" + this.one + ", five=" + this.five + ", fifteen=" + this.fifteen + '}';
    }
}

