/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.reporter.config.ConfigContext;
import java.io.Serializable;

public class BacktraceElement
implements Serializable {
    private static final long serialVersionUID = -4455225669072193184L;
    private final ConfigContext config;
    public final String file;
    public final String method;
    public final String number;
    public final String context;

    public BacktraceElement(ConfigContext config, String number, String file, String method) {
        this.config = config;
        this.number = number;
        this.file = file;
        this.method = method;
        this.context = this.calculateContext(method).getName();
    }

    public BacktraceElement(ConfigContext config, StackTraceElement element) {
        this.config = config;
        this.number = String.valueOf(element.getLineNumber());
        this.file = String.valueOf(element.getFileName());
        this.method = BacktraceElement.formatMethod(element);
        this.context = this.calculateContext(this.method).getName();
    }

    static String formatMethod(StackTraceElement element) {
        return String.format("%s.%s", element.getClassName(), element.getMethodName());
    }

    Context calculateContext(String method) {
        String appPackage = this.config.getApplicationPackage();
        Context methodContext = appPackage == null || appPackage.isEmpty() ? Context.ALL : (method == null || method.isEmpty() ? Context.ALL : (method.startsWith(appPackage) ? Context.APP : Context.ALL));
        return methodContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BacktraceElement that = (BacktraceElement)o;
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.number != null ? !this.number.equals(that.number) : that.number != null) {
            return false;
        }
        return !(this.context == null ? that.context != null : !this.context.equals(that.context));
    }

    public int hashCode() {
        int result = this.file != null ? this.file.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.number != null ? this.number.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }

    static enum Context {
        ALL("all"),
        APP("app");

        private final String name;

        private Context(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

