/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.github.mustachejava.util;

public class RingBuffer {
    private final int ringSize;
    private final int ringHash;
    private final char[] ring;
    private int length = 0;

    public RingBuffer(int ringSize) {
        int i;
        for (i = 1; i < ringSize; i *= 2) {
        }
        this.ringSize = i;
        this.ringHash = i - 1;
        this.ring = new char[i];
    }

    public void append(char c) {
        this.ring[this.length++ & this.ringHash] = c;
    }

    public void clear() {
        this.length = 0;
    }

    public boolean compare(String s, boolean exact) {
        int len = s.length();
        if (exact && len != this.length) {
            return false;
        }
        if (len > this.ringSize) {
            throw new IllegalArgumentException("Ring buffer too small: " + this.ringSize + " < " + s.length());
        }
        if (this.length >= len) {
            int j = 0;
            int position = this.length & this.ringHash;
            for (int i = position - len; i < position; ++i) {
                char c = i < 0 ? this.ring[this.ringSize + i] : this.ring[i];
                if (s.charAt(j++) == c) continue;
                return false;
            }
        }
        return true;
    }
}

