/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.github.mustachejava.codes;

import io.honeybadger.com.github.mustachejava.DefaultMustacheFactory;
import io.honeybadger.com.github.mustachejava.FragmentKey;
import io.honeybadger.com.github.mustachejava.MustacheException;
import io.honeybadger.com.github.mustachejava.TemplateContext;
import io.honeybadger.com.github.mustachejava.codes.DefaultCode;
import io.honeybadger.com.github.mustachejava.util.LatchedWriter;
import io.honeybadger.com.github.mustachejava.util.Node;
import io.honeybadger.com.github.mustachejava.util.NodeValue;
import io.honeybadger.com.google.common.base.Function;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueCode
extends DefaultCode {
    private final boolean encoded;
    private final ExecutorService les;
    private Pattern compiledAppended;

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                writer.write(this.tc.startChars());
                if (!this.encoded) {
                    writer.write("{");
                }
                writer.write(this.type);
                writer.write(this.name);
                if (!this.encoded) {
                    writer.write("}");
                }
                writer.write(this.tc.endChars());
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException(e);
        }
    }

    public ValueCode(TemplateContext tc, DefaultMustacheFactory df, String variable, boolean encoded) {
        super(tc, df, null, variable, "");
        this.encoded = encoded;
        this.les = df.getExecutorService();
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        try {
            Object object = this.get(scopes);
            if (object != null) {
                if (object instanceof Function) {
                    this.handleFunction(writer, (Function)object, scopes);
                } else {
                    if (object instanceof Callable) {
                        return this.handleCallable(writer, (Callable)object, scopes);
                    }
                    this.execute(writer, this.oh.stringify(object));
                }
            }
            return super.execute(writer, scopes);
        }
        catch (Exception e) {
            throw new MustacheException("Failed to get value for " + this.name, e, this.tc);
        }
    }

    protected Writer handleCallable(Writer writer, final Callable callable, Object[] scopes) throws Exception {
        if (this.les == null) {
            Object call = callable.call();
            this.execute(writer, call == null ? null : this.oh.stringify(call));
            return super.execute(writer, scopes);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new MustacheException("Failed to flush writer", e);
        }
        final LatchedWriter latchedWriter = new LatchedWriter(writer);
        final Writer finalWriter = writer;
        this.les.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object call = callable.call();
                    ValueCode.this.execute(finalWriter, call == null ? null : ValueCode.this.oh.stringify(call));
                    latchedWriter.done();
                }
                catch (Throwable e) {
                    latchedWriter.failed(e);
                }
            }
        });
        return super.execute((Writer)latchedWriter, scopes);
    }

    protected void handleFunction(Writer writer, Function function, Object[] scopes) throws IOException {
        String value;
        Object newtemplate = function.apply(null);
        if (newtemplate == null) {
            value = "";
        } else {
            String templateText = newtemplate.toString();
            StringWriter sw = new StringWriter();
            TemplateContext newTC = new TemplateContext("{{", "}}", this.tc.file(), this.tc.line(), this.tc.startOfLine());
            this.df.getFragment(new FragmentKey(newTC, templateText)).execute((Writer)sw, scopes).close();
            value = sw.toString();
        }
        this.execute(writer, value);
    }

    protected void execute(Writer writer, String value) throws IOException {
        if (value != null) {
            if (this.encoded) {
                this.df.encode(value, writer);
            } else {
                writer.write(value);
            }
        }
    }

    @Override
    public Node invert(Node node, String text, AtomicInteger position) {
        if (this.compiledAppended == null) {
            this.compiledAppended = this.appended == null ? Pattern.compile("$") : Pattern.compile(this.appended);
        }
        int start = position.get();
        Matcher matcher = this.compiledAppended.matcher(text);
        if (matcher.find(position.get())) {
            String value = text.substring(start, matcher.start());
            position.set(matcher.start() + matcher.group(0).length());
            node.put(this.name, NodeValue.value(value));
            return node;
        }
        return null;
    }
}

