/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Stats;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDetails
implements Serializable {
    private static final long serialVersionUID = 4689643321013504425L;
    private static Logger logger = LoggerFactory.getLogger(ServerDetails.class);
    public final String environment_name;
    public final String hostname;
    public final String project_root;
    public final Integer pid;
    public final String time;
    public final Stats stats;

    public ServerDetails(ConfigContext context) {
        this.environment_name = context.getEnvironment();
        this.hostname = ServerDetails.hostname();
        this.project_root = ServerDetails.projectRoot();
        this.pid = ServerDetails.pid();
        this.time = ServerDetails.time();
        this.stats = new Stats();
    }

    public ServerDetails(String environment_name, String hostname, String project_root, Integer pid, String time, Stats stats) {
        this.environment_name = environment_name;
        this.hostname = hostname;
        this.project_root = project_root;
        this.pid = pid;
        this.time = time;
        this.stats = stats;
    }

    protected static String hostname() {
        String host;
        if (System.getenv("HOSTNAME") != null) {
            host = System.getenv("HOSTNAME");
        } else if (System.getenv("COMPUTERNAME") != null) {
            host = System.getenv("COMPUTERNAME");
        } else {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.error("Unable to find hostname", (Throwable)e);
                host = "unknown";
            }
        }
        return host;
    }

    protected static String projectRoot() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Can't get runtime root path", (Throwable)e);
            return "unknown";
        }
    }

    protected static Integer pid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return null;
        }
        try {
            return Integer.parseInt(jvmName.substring(0, index));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String time() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        formatter.setTimeZone(tz);
        return formatter.format(new Date());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerDetails that = (ServerDetails)o;
        if (this.environment_name != null ? !this.environment_name.equals(that.environment_name) : that.environment_name != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.project_root != null ? !this.project_root.equals(that.project_root) : that.project_root != null) {
            return false;
        }
        return !(this.pid == null ? that.pid != null : !this.pid.equals(that.pid));
    }

    public int hashCode() {
        int result = this.environment_name != null ? this.environment_name.hashCode() : 0;
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.project_root != null ? this.project_root.hashCode() : 0);
        result = 31 * result + (this.pid != null ? this.pid.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServerDetails{environment_name='" + this.environment_name + '\'' + ", hostname='" + this.hostname + '\'' + ", project_root='" + this.project_root + '\'' + ", pid=" + this.pid + ", stats=" + this.stats + '}';
    }
}

