/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.CgiData;
import io.honeybadger.reporter.dto.Context;
import io.honeybadger.reporter.dto.Params;
import io.honeybadger.reporter.dto.Request;
import io.honeybadger.reporter.dto.Session;
import java.util.Iterator;
import play.mvc.Http;

public class PlayHttpRequestFactory {
    public static Request create(ConfigContext config, Http.Request httpRequest) {
        Context context = PlayHttpRequestFactory.createContext(httpRequest);
        String url = PlayHttpRequestFactory.getFullURL(httpRequest);
        Params params = PlayHttpRequestFactory.createParams(config, httpRequest);
        Session session = PlayHttpRequestFactory.createSession(httpRequest);
        CgiData cgi_data = PlayHttpRequestFactory.createCgiData(httpRequest);
        return new Request(context, url, params, session, cgi_data);
    }

    protected static Context createContext(Http.Request httpRequest) {
        Context context = new Context();
        String username = httpRequest.username();
        if (username != null) {
            context.put("user_name", username);
        }
        return context;
    }

    protected static String getFullURL(Http.Request httpRequest) {
        return httpRequest.uri();
    }

    protected static Params createParams(ConfigContext config, Http.Request httpRequest) {
        Http.RequestBody body = httpRequest.body();
        if (body == null) {
            return new Params(config.getExcludedParams());
        }
        return Params.parseParamsFromMap(config.getExcludedParams(), body.asFormUrlEncoded());
    }

    protected static Session createSession(Http.Request httpRequest) {
        Session session = new Session();
        return session;
    }

    protected static CgiData createCgiData(Http.Request httpRequest) {
        CgiData cgiData = new CgiData();
        cgiData.put("REQUEST_METHOD", httpRequest.method());
        cgiData.put("HTTP_ACCEPT", httpRequest.getHeader("Accept"));
        cgiData.put("HTTP_USER_AGENT", httpRequest.getHeader("User-Agent"));
        cgiData.put("HTTP_ACCEPT_ENCODING", httpRequest.getHeader("Accept-Encoding"));
        cgiData.put("HTTP_ACCEPT_LANGUAGE", httpRequest.getHeader("Accept-Language"));
        cgiData.put("HTTP_ACCEPT_CHARSET", httpRequest.getHeader("Accept-Charset"));
        cgiData.put("HTTP_COOKIE", PlayHttpRequestFactory.parseCookies(httpRequest));
        cgiData.put("CONTENT_TYPE", httpRequest.getHeader("Content-Type"));
        cgiData.put("CONTENT_LENGTH", httpRequest.getHeader("Content-Length"));
        cgiData.put("REMOTE_ADDR", httpRequest.remoteAddress());
        cgiData.put("QUERY_STRING", httpRequest.queryString());
        cgiData.put("PATH_INFO", httpRequest.path());
        if (httpRequest.host() != null && !httpRequest.host().isEmpty()) {
            String[] hostParts = httpRequest.host().split(":");
            if (hostParts.length > 0) {
                cgiData.put("SERVER_NAME", hostParts[0]);
            }
            if (hostParts.length > 1) {
                cgiData.put("SERVER_PORT", hostParts[1]);
            }
        }
        return cgiData;
    }

    static String parseCookies(Http.Request httpRequest) {
        Http.Cookies cookies = httpRequest.cookies();
        Iterator itr = cookies.iterator();
        if (cookies == null || !itr.hasNext()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (itr.hasNext()) {
            Http.Cookie next = (Http.Cookie)itr.next();
            String c = String.format("%s=%s", next.name(), next.value());
            builder.append(c.trim());
            if (!itr.hasNext()) continue;
            builder.append("; ");
        }
        return builder.toString();
    }
}

