/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.CgiData;
import io.honeybadger.reporter.dto.Context;
import io.honeybadger.reporter.dto.Params;
import io.honeybadger.reporter.dto.Request;
import io.honeybadger.reporter.dto.Session;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpServletRequestFactory {
    public static Request create(ConfigContext config, HttpServletRequest httpRequest) {
        Context context = HttpServletRequestFactory.createContext(httpRequest);
        String url = HttpServletRequestFactory.getFullURL(httpRequest);
        Params params = HttpServletRequestFactory.createParams(config, httpRequest);
        Session session = HttpServletRequestFactory.createSession(httpRequest);
        CgiData cgi_data = HttpServletRequestFactory.createCgiData(httpRequest);
        return new Request(context, url, params, session, cgi_data);
    }

    protected static Context createContext(HttpServletRequest httpRequest) {
        Context context = new Context();
        Principal principal = httpRequest.getUserPrincipal();
        if (principal != null) {
            context.put("user_name", principal.getName());
        }
        return context;
    }

    protected static Params createParams(ConfigContext config, HttpServletRequest httpRequest) {
        return Params.parseParamsFromMap(config.getExcludedParams(), httpRequest.getParameterMap());
    }

    protected static Session createSession(HttpServletRequest httpRequest) {
        Session session = new Session();
        HttpSession httpSession = httpRequest.getSession();
        if (httpSession == null) {
            return session;
        }
        try {
            session.put("session_id", (Object)httpSession.getId());
            session.put("creation_time", (Object)httpSession.getCreationTime());
            Enumeration attributes = httpSession.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String key = (String)attributes.nextElement();
                Object value = httpSession.getAttribute(key);
                if (value == null) continue;
                String valueAsString = String.valueOf(value);
                String subString = valueAsString.length() > 4096 ? valueAsString.substring(0, 4096) : valueAsString;
                session.put(key, (Object)subString);
            }
        }
        catch (RuntimeException e) {
            session.put("Error getting session", (Object)e.getMessage());
        }
        return session;
    }

    protected static CgiData createCgiData(HttpServletRequest httpRequest) {
        CgiData cgiData = new CgiData();
        cgiData.put("REQUEST_METHOD", httpRequest.getMethod());
        cgiData.put("HTTP_ACCEPT", httpRequest.getHeader("Accept"));
        cgiData.put("HTTP_USER_AGENT", httpRequest.getHeader("User-Agent"));
        cgiData.put("HTTP_ACCEPT_ENCODING", httpRequest.getHeader("Accept-Encoding"));
        cgiData.put("HTTP_ACCEPT_LANGUAGE", httpRequest.getHeader("Accept-Language"));
        cgiData.put("HTTP_ACCEPT_CHARSET", httpRequest.getHeader("Accept-Charset"));
        cgiData.put("HTTP_COOKIE", HttpServletRequestFactory.parseCookies(httpRequest));
        cgiData.put("SERVER_NAME", httpRequest.getServerName());
        cgiData.put("SERVER_PORT", httpRequest.getServerPort());
        cgiData.put("CONTENT_TYPE", httpRequest.getContentType());
        cgiData.put("CONTENT_LENGTH", httpRequest.getContentLength());
        cgiData.put("REMOTE_ADDR", httpRequest.getRemoteAddr());
        cgiData.put("REMOTE_PORT", httpRequest.getRemotePort());
        cgiData.put("QUERY_STRING", httpRequest.getQueryString());
        cgiData.put("PATH_INFO", httpRequest.getPathInfo());
        return cgiData;
    }

    static String parseCookies(HttpServletRequest request) {
        Enumeration cookies = request.getHeaders("Set-Cookie");
        if (cookies == null || !cookies.hasMoreElements()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (cookies.hasMoreElements()) {
            String c = (String)cookies.nextElement();
            if (c == null) continue;
            builder.append(c.trim());
            if (!cookies.hasMoreElements()) continue;
            builder.append("; ");
        }
        return builder.toString();
    }

    protected static String getFullURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (requestURL == null) {
            return null;
        }
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }
}

