/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.config;

import io.honeybadger.reporter.config.BaseChainedConfigContext;
import io.honeybadger.reporter.config.MapConfigContext;
import io.honeybadger.reporter.config.SystemSettingsConfigContext;
import io.honeybadger.util.HBStringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;
import play.Configuration;
import play.Environment;

public class PlayConfigContext
extends BaseChainedConfigContext {
    public PlayConfigContext(Configuration configuration, Environment environment) {
        String env = environment == null ? "UNKNOWN" : (environment.mode().name() == null || environment.mode().name().isEmpty() ? "UNKNOWN" : environment.mode().name());
        if (configuration != null) {
            Map<String, Object> configMap = PlayConfigContext.flattenNestedMap(configuration.asMap());
            MapConfigContext mapContext = new MapConfigContext(configMap);
            mapContext.put("ENV", env);
            this.overwriteWithContext(mapContext);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Null Play configuration. Using defaults and system settings.");
            this.overwriteWithContext(new SystemSettingsConfigContext());
        }
    }

    static Map<String, Object> flattenNestedMap(Map<String, Object> map) {
        return PlayConfigContext.flattenNestedMap(map, 0L);
    }

    static Map<String, Object> flattenNestedMap(Map<String, Object> map, long level) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> flat = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            if (entry.getKey() == null || entry.getKey().isEmpty()) continue;
            if (entry.getValue() instanceof Map) {
                Map innerMap = (Map)entry.getValue();
                if (innerMap.isEmpty()) continue;
                Map<String, Object> subFlat = PlayConfigContext.flattenNestedMap(innerMap, level + 1L);
                for (Map.Entry<String, Object> subEntry : subFlat.entrySet()) {
                    String subKey = HBStringUtils.stripTrailingChar(subEntry.getKey(), '.');
                    String key2 = String.format("%s.%s", entry.getKey(), subKey);
                    flat.put(key2, subEntry.getValue());
                }
                continue;
            }
            if (level == 0L) {
                key = HBStringUtils.stripTrailingChar(entry.getKey(), '.');
                flat.put(String.format("%s", key), entry.getValue());
                continue;
            }
            key = HBStringUtils.stripTrailingChar(entry.getKey(), '.');
            flat.put(String.format("%s.", key), entry.getValue());
        }
        return flat;
    }
}

