/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.org.apache.http.impl.client;

import io.honeybadger.org.apache.http.annotation.Immutable;
import io.honeybadger.org.apache.http.conn.HttpClientConnectionManager;
import io.honeybadger.org.apache.http.impl.client.CloseableHttpClient;
import io.honeybadger.org.apache.http.impl.client.HttpClientBuilder;
import io.honeybadger.org.apache.http.impl.client.MinimalHttpClient;
import io.honeybadger.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

@Immutable
public class HttpClients {
    private HttpClients() {
    }

    public static HttpClientBuilder custom() {
        return HttpClientBuilder.create();
    }

    public static CloseableHttpClient createDefault() {
        return HttpClientBuilder.create().build();
    }

    public static CloseableHttpClient createSystem() {
        return HttpClientBuilder.create().useSystemProperties().build();
    }

    public static CloseableHttpClient createMinimal() {
        return new MinimalHttpClient(new PoolingHttpClientConnectionManager());
    }

    public static CloseableHttpClient createMinimal(HttpClientConnectionManager connManager) {
        return new MinimalHttpClient(connManager);
    }
}

