/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.github.mustachejava;

import io.honeybadger.com.github.mustachejava.DefaultMustacheVisitor;
import io.honeybadger.com.github.mustachejava.FragmentKey;
import io.honeybadger.com.github.mustachejava.Mustache;
import io.honeybadger.com.github.mustachejava.MustacheException;
import io.honeybadger.com.github.mustachejava.MustacheFactory;
import io.honeybadger.com.github.mustachejava.MustacheNotFoundException;
import io.honeybadger.com.github.mustachejava.MustacheParser;
import io.honeybadger.com.github.mustachejava.MustacheResolver;
import io.honeybadger.com.github.mustachejava.MustacheVisitor;
import io.honeybadger.com.github.mustachejava.ObjectHandler;
import io.honeybadger.com.github.mustachejava.TemplateContext;
import io.honeybadger.com.github.mustachejava.reflect.ReflectionObjectHandler;
import io.honeybadger.com.github.mustachejava.resolver.DefaultResolver;
import io.honeybadger.com.github.mustachejava.util.HtmlEscaper;
import io.honeybadger.com.google.common.cache.CacheBuilder;
import io.honeybadger.com.google.common.cache.CacheLoader;
import io.honeybadger.com.google.common.cache.LoadingCache;
import io.honeybadger.com.google.common.io.Files;
import io.honeybadger.com.google.common.util.concurrent.ListeningExecutorService;
import io.honeybadger.com.google.common.util.concurrent.MoreExecutors;
import io.honeybadger.com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class DefaultMustacheFactory
implements MustacheFactory {
    protected final LoadingCache<String, Mustache> mustacheCache = this.createMustacheCache();
    protected ObjectHandler oh = new ReflectionObjectHandler();
    protected final MustacheParser mc = new MustacheParser(this);
    protected final LoadingCache<FragmentKey, Mustache> templateCache = this.createLambdaCache();
    protected int recursionLimit = 100;
    private final MustacheResolver mustacheResolver;
    protected ListeningExecutorService les;
    private final ThreadLocal<Map<String, Mustache>> partialCache = new ThreadLocal<Map<String, Mustache>>(){

        @Override
        protected Map<String, Mustache> initialValue() {
            return new HashMap<String, Mustache>();
        }
    };

    public DefaultMustacheFactory() {
        this.mustacheResolver = new DefaultResolver();
    }

    public DefaultMustacheFactory(MustacheResolver mustacheResolver) {
        this.mustacheResolver = mustacheResolver;
    }

    public DefaultMustacheFactory(String resourceRoot) {
        this.mustacheResolver = new DefaultResolver(resourceRoot);
    }

    public DefaultMustacheFactory(File fileRoot) {
        this.mustacheResolver = new DefaultResolver(fileRoot);
    }

    public String resolvePartialPath(String dir, String name, String extension) {
        String filePath = name;
        if (!name.startsWith("/")) {
            filePath = dir + filePath;
        }
        if (!name.endsWith(extension)) {
            filePath = filePath + extension;
        }
        String path = Files.simplifyPath(new File(filePath).getPath());
        return DefaultMustacheFactory.ensureForwardSlash(path);
    }

    private static String ensureForwardSlash(String path) {
        return path.replace('\\', '/');
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        return new DefaultMustacheVisitor(this);
    }

    @Override
    public Reader getReader(String resourceName) {
        Reader reader = this.mustacheResolver.getReader(resourceName);
        if (reader == null) {
            throw new MustacheNotFoundException(resourceName);
        }
        return reader;
    }

    @Override
    public void encode(String value, Writer writer) {
        HtmlEscaper.escape(value, writer, true);
    }

    @Override
    public ObjectHandler getObjectHandler() {
        return this.oh;
    }

    public void setObjectHandler(ObjectHandler oh) {
        this.oh = oh;
    }

    public ExecutorService getExecutorService() {
        return this.les;
    }

    public void setExecutorService(ExecutorService es) {
        this.les = es instanceof ListeningExecutorService ? (ListeningExecutorService)es : MoreExecutors.listeningDecorator(es);
    }

    public Mustache getFragment(FragmentKey templateKey) {
        try {
            Mustache mustache = this.templateCache.get(templateKey);
            mustache.init();
            return mustache;
        }
        catch (ExecutionException e) {
            throw this.handle(e);
        }
    }

    private MustacheException handle(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof MustacheException) {
            return (MustacheException)cause;
        }
        return new MustacheException(cause);
    }

    @Override
    public Mustache compile(String name) {
        try {
            Mustache mustache = this.mustacheCache.get(name);
            mustache.init();
            return mustache;
        }
        catch (UncheckedExecutionException e) {
            throw this.handle(e);
        }
        catch (ExecutionException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Mustache compile(Reader reader, String name) {
        return this.compile(reader, name, "{{", "}}");
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        Mustache compile = this.mc.compile(reader, file, sm, em);
        compile.init();
        return compile;
    }

    @Override
    public String translate(String from) {
        return from;
    }

    public String filterText(String appended, boolean b) {
        return appended;
    }

    public void setRecursionLimit(int recursionLimit) {
        this.recursionLimit = recursionLimit;
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mustache compilePartial(String s) {
        Map<String, Mustache> cache = this.partialCache.get();
        try {
            Mustache mustache = cache.get(s);
            if (mustache == null) {
                mustache = this.mc.compile(s);
                cache.put(s, mustache);
                mustache.init();
            }
            Mustache mustache2 = mustache;
            return mustache2;
        }
        finally {
            cache.remove(s);
        }
    }

    protected LoadingCache<String, Mustache> createMustacheCache() {
        return CacheBuilder.newBuilder().build(new MustacheCacheLoader());
    }

    protected LoadingCache<FragmentKey, Mustache> createLambdaCache() {
        return CacheBuilder.newBuilder().build(new FragmentCacheLoader());
    }

    protected class FragmentCacheLoader
    extends CacheLoader<FragmentKey, Mustache> {
        protected FragmentCacheLoader() {
        }

        @Override
        public Mustache load(FragmentKey fragmentKey) throws Exception {
            StringReader reader = new StringReader(fragmentKey.templateText);
            TemplateContext tc = fragmentKey.tc;
            return DefaultMustacheFactory.this.mc.compile(reader, tc.file(), tc.startChars(), tc.endChars(), tc.startOfLine());
        }
    }

    protected class MustacheCacheLoader
    extends CacheLoader<String, Mustache> {
        protected MustacheCacheLoader() {
        }

        @Override
        public Mustache load(String key) throws Exception {
            return DefaultMustacheFactory.this.mc.compile(key);
        }
    }
}

