/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.config;

import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.config.DefaultsConfigContext;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseChainedConfigContext
implements ConfigContext {
    protected String environment;
    protected URI honeybadgerUrl;
    protected String apiKey;
    protected Set<String> excludedSysProps = new HashSet<String>();
    protected Set<String> excludedParams = new HashSet<String>();
    protected Set<String> excludedClasses = new HashSet<String>();
    protected String applicationPackage;
    protected String honeybadgerReadApiKey;
    protected Boolean feedbackFormDisplayed;
    protected String feedbackFormPath;
    protected String httpProxyHost;
    protected Integer httpProxyPort;
    public static final ConfigContext DEFAULT_CONFIG = new DefaultsConfigContext();

    public BaseChainedConfigContext() {
        this(DEFAULT_CONFIG);
    }

    public BaseChainedConfigContext(ConfigContext defaultingContext) {
        this.overwriteWithContext(defaultingContext);
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public URI getHoneybadgerUrl() {
        return this.honeybadgerUrl;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public Set<String> getExcludedSysProps() {
        return this.excludedSysProps;
    }

    @Override
    public Set<String> getExcludedParams() {
        return this.excludedParams;
    }

    @Override
    public Set<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    @Override
    public String getApplicationPackage() {
        return this.applicationPackage;
    }

    @Override
    public String getHoneybadgerReadApiKey() {
        return this.honeybadgerReadApiKey;
    }

    @Override
    public Boolean isFeedbackFormDisplayed() {
        return this.feedbackFormDisplayed;
    }

    @Override
    public String getFeedbackFormPath() {
        return this.feedbackFormPath;
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Override
    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void overwriteWithContext(ConfigContext context) {
        if (this.isPresent(context.getEnvironment())) {
            this.environment = context.getEnvironment();
        }
        if (context.getHoneybadgerUrl() != null) {
            this.honeybadgerUrl = context.getHoneybadgerUrl();
        }
        if (this.isPresent(context.getApiKey())) {
            this.apiKey = context.getApiKey();
        }
        if (this.isPresent(context.getExcludedSysProps())) {
            HashSet<String> set = new HashSet<String>(context.getExcludedSysProps());
            set.add("honeybadger.api_key");
            set.add("honeybadger.excluded_sys_props");
            set.add("honeybadger.url");
            this.excludedSysProps = set;
        }
        if (this.isPresent(context.getExcludedParams())) {
            this.excludedParams = context.getExcludedParams();
        }
        if (this.isPresent(context.getExcludedClasses())) {
            this.excludedClasses = context.getExcludedClasses();
        }
        if (this.isPresent(context.getApplicationPackage())) {
            this.applicationPackage = context.getApplicationPackage();
        }
        if (this.isPresent(context.getHoneybadgerReadApiKey())) {
            this.honeybadgerReadApiKey = context.getHoneybadgerReadApiKey();
        }
        if (context.isFeedbackFormDisplayed() != null) {
            this.feedbackFormDisplayed = context.isFeedbackFormDisplayed();
        }
        if (this.isPresent(context.getFeedbackFormPath())) {
            this.feedbackFormPath = context.getFeedbackFormPath();
        }
    }

    protected boolean isPresent(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    protected boolean isPresent(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public BaseChainedConfigContext setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public BaseChainedConfigContext setHoneybadgerUrl(URI honeybadgerUrl) {
        this.honeybadgerUrl = honeybadgerUrl;
        return this;
    }

    public BaseChainedConfigContext setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public BaseChainedConfigContext setExcludedSysProps(Set<String> excludedSysProps) {
        this.excludedSysProps = excludedSysProps;
        return this;
    }

    public BaseChainedConfigContext setExcludedParams(Set<String> excludedParams) {
        this.excludedParams = excludedParams;
        return this;
    }

    public BaseChainedConfigContext setExcludedClasses(Set<String> excludedClasses) {
        this.excludedClasses = excludedClasses;
        return this;
    }

    public BaseChainedConfigContext setApplicationPackage(String applicationPackage) {
        this.applicationPackage = applicationPackage;
        return this;
    }

    public BaseChainedConfigContext setHoneybadgerReadApiKey(String honeybadgerReadApiKey) {
        this.honeybadgerReadApiKey = honeybadgerReadApiKey;
        return this;
    }

    public BaseChainedConfigContext setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
        return this;
    }

    public BaseChainedConfigContext setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
        return this;
    }

    public Boolean setFeedbackFormDisplayed(Boolean feedbackFormDisplayed) {
        if (feedbackFormDisplayed == null) {
            throw new IllegalArgumentException("This value should be only null during initialization");
        }
        this.feedbackFormDisplayed = feedbackFormDisplayed;
        return feedbackFormDisplayed;
    }

    public BaseChainedConfigContext setFeedbackFormPath(String feedbackFormPath) {
        this.feedbackFormPath = feedbackFormPath;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseChainedConfigContext that = (BaseChainedConfigContext)o;
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        if (this.honeybadgerUrl != null ? !this.honeybadgerUrl.equals(that.honeybadgerUrl) : that.honeybadgerUrl != null) {
            return false;
        }
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.excludedSysProps != null ? !this.excludedSysProps.equals(that.excludedSysProps) : that.excludedSysProps != null) {
            return false;
        }
        if (this.excludedParams != null ? !this.excludedParams.equals(that.excludedParams) : that.excludedParams != null) {
            return false;
        }
        if (this.excludedClasses != null ? !this.excludedClasses.equals(that.excludedClasses) : that.excludedClasses != null) {
            return false;
        }
        if (this.applicationPackage != null ? !this.applicationPackage.equals(that.applicationPackage) : that.applicationPackage != null) {
            return false;
        }
        if (this.honeybadgerReadApiKey != null ? !this.honeybadgerReadApiKey.equals(that.honeybadgerReadApiKey) : that.honeybadgerReadApiKey != null) {
            return false;
        }
        if (this.feedbackFormDisplayed != null ? !this.feedbackFormDisplayed.equals(that.feedbackFormDisplayed) : that.feedbackFormDisplayed != null) {
            return false;
        }
        if (this.feedbackFormPath != null ? !this.feedbackFormPath.equals(that.feedbackFormPath) : that.feedbackFormPath != null) {
            return false;
        }
        if (this.httpProxyHost != null ? !this.httpProxyHost.equals(that.httpProxyHost) : that.httpProxyHost != null) {
            return false;
        }
        return !(this.httpProxyPort == null ? that.httpProxyPort != null : !this.httpProxyPort.equals(that.httpProxyPort));
    }

    public int hashCode() {
        int result = this.environment != null ? this.environment.hashCode() : 0;
        result = 31 * result + (this.honeybadgerUrl != null ? this.honeybadgerUrl.hashCode() : 0);
        result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
        result = 31 * result + (this.excludedSysProps != null ? this.excludedSysProps.hashCode() : 0);
        result = 31 * result + (this.excludedParams != null ? this.excludedParams.hashCode() : 0);
        result = 31 * result + (this.excludedClasses != null ? this.excludedClasses.hashCode() : 0);
        result = 31 * result + (this.applicationPackage != null ? this.applicationPackage.hashCode() : 0);
        result = 31 * result + (this.honeybadgerReadApiKey != null ? this.honeybadgerReadApiKey.hashCode() : 0);
        result = 31 * result + (this.feedbackFormDisplayed != null ? this.feedbackFormDisplayed.hashCode() : 0);
        result = 31 * result + (this.feedbackFormPath != null ? this.feedbackFormPath.hashCode() : 0);
        result = 31 * result + (this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0);
        result = 31 * result + (this.httpProxyPort != null ? this.httpProxyPort.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BaseChainedConfigContext{");
        sb.append("environment='").append(this.environment).append('\'');
        sb.append(", honeybadgerUrl='").append(this.honeybadgerUrl).append('\'');
        sb.append(", apiKey='").append(this.apiKey).append('\'');
        sb.append(", excludedSysProps=").append(this.excludedSysProps);
        sb.append(", excludedParams=").append(this.excludedParams);
        sb.append(", excludedClasses=").append(this.excludedClasses);
        sb.append(", applicationPackage='").append(this.applicationPackage).append('\'');
        sb.append(", honeybadgerReadApiKey='").append(this.honeybadgerReadApiKey).append('\'');
        sb.append(", feedbackFormDisplayed=").append(this.feedbackFormDisplayed);
        sb.append(", feedbackFormPath='").append(this.feedbackFormPath).append('\'');
        sb.append(", httpProxyHost='").append(this.httpProxyHost).append('\'');
        sb.append(", httpProxyPort=").append(this.httpProxyPort);
        sb.append('}');
        return sb.toString();
    }
}

