/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.loader;

import io.honeybadger.com.google.gson.Gson;
import io.honeybadger.com.google.gson.GsonBuilder;
import io.honeybadger.com.google.gson.JsonElement;
import io.honeybadger.com.google.gson.JsonObject;
import io.honeybadger.org.apache.http.HttpResponse;
import io.honeybadger.org.apache.http.client.fluent.Request;
import io.honeybadger.org.apache.http.client.fluent.Response;
import io.honeybadger.reporter.HoneybadgerExclusionStrategy;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Notice;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoneybadgerNoticeLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Gson gson = new GsonBuilder().setExclusionStrategies(new HoneybadgerExclusionStrategy()).create();
    private ConfigContext config;

    public HoneybadgerNoticeLoader(ConfigContext config) {
        this.config = config;
    }

    String pullFaultJson(UUID faultId) throws IOException {
        String readApiKey = this.config.getHoneybadgerReadApiKey();
        if (readApiKey == null) {
            String msg = "Read API key must be set";
            throw new IllegalArgumentException(msg);
        }
        URI baseURI = URI.create(String.format("%s/%s/%s", this.config.getHoneybadgerUrl(), "v1/notices", faultId));
        String withAuth = String.format("%s/?auth_token=%s", baseURI, readApiKey);
        this.logger.debug("Querying for error details: {}", (Object)baseURI);
        Response response = null;
        HttpResponse httpResponse = null;
        for (int i = 0; i < 3 && (httpResponse = (response = Request.Get(withAuth).addHeader("Accept", "application/json").execute()).returnResponse()).getStatusLine().getStatusCode() != 200; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (i != 2) continue;
            throw new IllegalArgumentException("Unable to get notice from API");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpResponse.getEntity().writeTo(out);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notice findErrorDetails(UUID faultId) throws IOException {
        Notice error;
        String json = this.pullFaultJson(faultId);
        JsonObject originalJson = this.gson.fromJson(json, JsonObject.class).getAsJsonObject();
        JsonObject cgiData = originalJson.get("web_environment").getAsJsonObject();
        originalJson.get("request").getAsJsonObject().add("cgi_data", cgiData);
        try {
            ConfigContext.threadLocal.set(this.config);
            error = this.gson.fromJson((JsonElement)originalJson, Notice.class);
        }
        finally {
            ConfigContext.threadLocal.remove();
        }
        return error;
    }
}

