/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import io.honeybadger.com.jcabi.log.DecorException;
import java.io.StringWriter;
import java.util.Formattable;
import java.util.Formatter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

final class DomDecor
implements Formattable {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private final transient Node node;

    DomDecor(Object doc) throws DecorException {
        if (doc != null && !(doc instanceof Node)) {
            throw new DecorException(String.format("Instance of org.w3c.dom.Node required, while %s provided", doc.getClass().getName()), new Object[0]);
        }
        this.node = (Node)doc;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        StringWriter writer = new StringWriter();
        if (this.node == null) {
            writer.write("NULL");
        } else {
            try {
                Transformer trans = FACTORY.newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("standalone", "no");
                trans.transform(new DOMSource(this.node), new StreamResult(writer));
            }
            catch (TransformerConfigurationException ex) {
                throw new IllegalStateException(ex);
            }
            catch (TransformerException ex) {
                throw new IllegalStateException(ex);
            }
        }
        formatter.format("%s", writer.toString());
    }

    public String toString() {
        return "DomDecor(node=" + this.node + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomDecor)) {
            return false;
        }
        DomDecor other = (DomDecor)o;
        Node this$node = this.node;
        Node other$node = other.node;
        return !(this$node == null ? other$node != null : !this$node.equals(other$node));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Node $node = this.node;
        result = result * 59 + ($node == null ? 0 : $node.hashCode());
        return result;
    }
}

