/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import java.io.Serializable;

public class Memory
implements Serializable {
    private static final long serialVersionUID = -8799953046383217102L;
    public final Number total;
    public final Number free;
    public final Number buffers;
    public final Number cached;
    public final Number free_total;

    public Memory() {
        long mebibyte = 0x100000L;
        Runtime r = Runtime.getRuntime();
        this.total = r.maxMemory() / 0x100000L;
        this.free = r.freeMemory() / 0x100000L;
        this.buffers = -1;
        this.cached = -1;
        this.free_total = (r.maxMemory() - (r.totalMemory() + r.freeMemory())) / 0x100000L;
    }

    public Memory(Number total, Number free, Number buffers, Number cached, Number free_total) {
        this.total = total;
        this.free = free;
        this.buffers = buffers;
        this.cached = cached;
        this.free_total = free_total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Memory memory = (Memory)o;
        if (this.total != null ? !this.total.equals(memory.total) : memory.total != null) {
            return false;
        }
        if (this.free != null ? !this.free.equals(memory.free) : memory.free != null) {
            return false;
        }
        if (this.buffers != null ? !this.buffers.equals(memory.buffers) : memory.buffers != null) {
            return false;
        }
        if (this.cached != null ? !this.cached.equals(memory.cached) : memory.cached != null) {
            return false;
        }
        return !(this.free_total == null ? memory.free_total != null : !this.free_total.equals(memory.free_total));
    }

    public int hashCode() {
        int result = this.total != null ? this.total.hashCode() : 0;
        result = 31 * result + (this.free != null ? this.free.hashCode() : 0);
        result = 31 * result + (this.buffers != null ? this.buffers.hashCode() : 0);
        result = 31 * result + (this.cached != null ? this.cached.hashCode() : 0);
        result = 31 * result + (this.free_total != null ? this.free_total.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Memory{total=" + this.total + ", free=" + this.free + ", buffers=" + this.buffers + ", cached=" + this.cached + ", free_total=" + this.free_total + '}';
    }
}

