/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;

final class SecretDecor
implements Formattable {
    private final transient String secret;

    SecretDecor(Object scrt) {
        this.secret = scrt == null ? null : scrt.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.secret == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder fmt = new StringBuilder(10);
            fmt.append('%');
            if ((flags & 1) != 0) {
                fmt.append('-');
            }
            if (width != 0) {
                fmt.append(width);
            }
            if ((flags & 2) == 0) {
                fmt.append('s');
            } else {
                fmt.append('S');
            }
            formatter.format(fmt.toString(), SecretDecor.scramble(this.secret));
        }
    }

    private static String scramble(String text) {
        StringBuilder out = new StringBuilder(10);
        if (text.isEmpty()) {
            out.append('?');
        } else {
            out.append(text.charAt(0));
        }
        out.append("***");
        if (text.isEmpty()) {
            out.append('?');
        } else {
            out.append(text.charAt(text.length() - 1));
        }
        return out.toString();
    }

    public String toString() {
        return "SecretDecor(secret=" + this.secret + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretDecor)) {
            return false;
        }
        SecretDecor other = (SecretDecor)o;
        String this$secret = this.secret;
        String other$secret = other.secret;
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $secret = this.secret;
        result = result * 59 + ($secret == null ? 0 : $secret.hashCode());
        return result;
    }
}

