/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.reporter.config.ConfigContext;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Set;

public class Params
extends LinkedHashMap<String, String>
implements Serializable {
    private static final long serialVersionUID = -5633548926144410598L;
    private final Set<String> excludedValues;

    public Params(Set<String> excludedValues) {
        this.excludedValues = excludedValues;
    }

    public Params() {
        ConfigContext config = ConfigContext.threadLocal.get();
        if (config == null) {
            throw new NullPointerException("Unable to get the expected ConfigContext from ThreadLocal");
        }
        this.excludedValues = config.getExcludedParams();
    }

    static String csv(String[] strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            builder.append(strings[i]);
            if (i >= strings.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public String put(String key, String value) {
        if (this.excludedValues.contains(key)) {
            return null;
        }
        return super.put(key, value);
    }
}

