/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.config;

import io.honeybadger.reporter.config.ConfigContext;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapConfigContext
implements ConfigContext {
    public static final String ENVIRONMENT_KEY = "ENV";
    public static final String JAVA_ENVIRONMENT_KEY = "JAVA_ENV";
    public static final String HONEYBADGER_URL_KEY = "honeybadger.url";
    public static final String HONEYBADGER_API_KEY = "honeybadger.api_key";
    public static final String HONEYBADGER_API_KEY_ENV = "HONEYBADGER_API_KEY";
    public static final String HONEYBADGER_EXCLUDED_PROPS_KEY = "honeybadger.excluded_sys_props";
    public static final String HONEYBADGER_EXCLUDED_PARAMS_KEY = "honeybadger.excluded_params";
    public static final String HONEYBADGER_EXCLUDED_CLASSES_KEY = "honeybadger.excluded_exception_classes";
    public static final String APPLICATION_PACKAGE_PROP_KEY = "honeybadger.application_package";
    public static final String READ_API_KEY_PROP_KEY = "honeybadger.read_api_key";
    public static final String READ_API_KEY_ENV = "HONEYBADGER_READ_API_KEY";
    public static final String DISPLAY_FEEDBACK_FORM_KEY = "honeybadger.display_feedback_form";
    public static final String FEEDBACK_FORM_TEMPLATE_PATH_KEY = "honeybadger.feedback_form_template_path";
    public static final String HTTP_PROXY_HOST_KEY = "http.proxyHost";
    public static final String HTTP_PROXY_PORT_KEY = "http.proxyPort";
    private final Map<?, ?> backingMap;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MapConfigContext(Map<?, ?> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public String getEnvironment() {
        String env = this.normalizeEmptyAndNullAndDefaultToStringValue(ENVIRONMENT_KEY);
        if (env == null) {
            return this.normalizeEmptyAndNullAndDefaultToStringValue(JAVA_ENVIRONMENT_KEY);
        }
        return env;
    }

    @Override
    public URI getHoneybadgerUrl() {
        Object value = this.backingMap.get(HONEYBADGER_API_KEY);
        if (value == null) {
            return null;
        }
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof String) {
            String uri = this.normalizeEmptyAndNullAndDefaultToStringValue(HONEYBADGER_URL_KEY);
            if (uri == null) {
                return null;
            }
            try {
                return URI.create(uri);
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Honeybadger URL was not correctly formed. Property: {}", (Object)HONEYBADGER_API_KEY);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getApiKey() {
        String env = this.normalizeEmptyAndNullAndDefaultToStringValue(HONEYBADGER_API_KEY_ENV);
        if (env == null) {
            return this.normalizeEmptyAndNullAndDefaultToStringValue(HONEYBADGER_API_KEY);
        }
        return env;
    }

    @Override
    public Set<String> getExcludedSysProps() {
        return this.parseCsvStringSetOrPassOnObject(HONEYBADGER_EXCLUDED_PROPS_KEY);
    }

    @Override
    public Set<String> getExcludedParams() {
        return this.parseCsvStringSetOrPassOnObject(HONEYBADGER_EXCLUDED_PARAMS_KEY);
    }

    @Override
    public Set<String> getExcludedClasses() {
        return this.parseCsvStringSetOrPassOnObject(HONEYBADGER_EXCLUDED_CLASSES_KEY);
    }

    @Override
    public String getApplicationPackage() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(APPLICATION_PACKAGE_PROP_KEY);
    }

    @Override
    public String getHoneybadgerReadApiKey() {
        String env = this.normalizeEmptyAndNullAndDefaultToStringValue(READ_API_KEY_ENV);
        if (env == null) {
            return this.normalizeEmptyAndNullAndDefaultToStringValue(READ_API_KEY_PROP_KEY);
        }
        return env;
    }

    @Override
    public Boolean isFeedbackFormDisplayed() {
        return this.parseBoolean(DISPLAY_FEEDBACK_FORM_KEY);
    }

    @Override
    public String getFeedbackFormPath() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(FEEDBACK_FORM_TEMPLATE_PATH_KEY);
    }

    @Override
    public String getHttpProxyHost() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(HTTP_PROXY_HOST_KEY);
    }

    @Override
    public Integer getHttpProxyPort() {
        Object value = this.backingMap.get(HTTP_PROXY_PORT_KEY);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String port = this.normalizeEmptyAndNullAndDefaultToStringValue(HTTP_PROXY_PORT_KEY);
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.logger.warn("Error converting system property to integer. Property: {}", (Object)HTTP_PROXY_PORT_KEY);
            return null;
        }
    }

    Object put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Config key can't be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Config key can't be blank");
        }
        Map<?, ?> map = this.backingMap;
        return map.put(key, value);
    }

    private String normalizeEmptyAndNullAndDefaultToStringValue(Object key) {
        Object value = this.backingMap.get(key);
        if (value == null) {
            return null;
        }
        String stringValue = value.toString();
        if (stringValue.isEmpty()) {
            return null;
        }
        return stringValue;
    }

    private Boolean parseBoolean(Object key) {
        Object value = this.backingMap.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof CharSequence) {
            String stringValue = value.toString().toLowerCase();
            if (stringValue.isEmpty()) {
                return null;
            }
            if (stringValue.equals("true") || stringValue.equals("on")) {
                return true;
            }
            if (stringValue.equals("false") || stringValue.equals("off")) {
                return false;
            }
            this.logger.warn("Unknown value for boolean with property: {}", key);
            return null;
        }
        return null;
    }

    private Set<String> parseCsvStringSetOrPassOnObject(Object key) {
        Object value = this.backingMap.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection<String> collection = Collections.checkedCollection((Collection)value, String.class);
            return new HashSet<String>(collection);
        }
        if (value instanceof String) {
            String stringValue = this.normalizeEmptyAndNullAndDefaultToStringValue(key);
            if (stringValue == null) {
                return null;
            }
            HashSet<String> set = new HashSet<String>();
            Collections.addAll(set, stringValue.split(","));
            return set;
        }
        this.logger.warn("Unknown object value for property: [key={}, value={}]", key, value);
        return null;
    }
}

