/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.github.mustachejava.reflect;

import io.honeybadger.com.github.mustachejava.MustacheException;
import io.honeybadger.com.github.mustachejava.ObjectHandler;
import io.honeybadger.com.github.mustachejava.reflect.Guard;
import io.honeybadger.com.github.mustachejava.reflect.GuardedWrapper;
import io.honeybadger.com.github.mustachejava.reflect.ReflectionObjectHandler;
import io.honeybadger.com.github.mustachejava.util.GuardException;
import io.honeybadger.com.github.mustachejava.util.Wrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ReflectionWrapper
extends GuardedWrapper {
    protected final int scopeIndex;
    protected final Wrapper[] wrappers;
    protected final ObjectHandler oh;
    protected final Method method;
    protected final Field field;
    protected final Object[] arguments;

    public ReflectionWrapper(int scopeIndex, Wrapper[] wrappers, Guard[] guard, AccessibleObject method, Object[] arguments, ObjectHandler oh) {
        super(guard);
        this.wrappers = wrappers;
        this.oh = oh;
        if (method instanceof Field) {
            this.method = null;
            this.field = (Field)method;
        } else {
            this.method = (Method)method;
            this.field = null;
        }
        this.arguments = arguments;
        this.scopeIndex = scopeIndex;
    }

    public ReflectionWrapper(ReflectionWrapper rw) {
        this(rw.scopeIndex, rw.wrappers, rw.guards, rw.method == null ? rw.field : rw.method, rw.arguments, rw.oh);
    }

    protected Object unwrap(Object[] scopes) {
        if (this.wrappers == null || this.wrappers.length == 0) {
            return scopes[this.scopeIndex];
        }
        return ReflectionObjectHandler.unwrap(this.oh, this.scopeIndex, this.wrappers, scopes);
    }

    @Override
    public Object call(Object[] scopes) throws GuardException {
        this.guardCall(scopes);
        Object scope = this.oh.coerce(this.unwrap(scopes));
        try {
            if (scope == null) {
                return null;
            }
            if (this.method == null) {
                return this.field.get(scope);
            }
            return this.method.invoke(scope, this.arguments);
        }
        catch (IllegalArgumentException e) {
            throw new MustacheException("Error accessing " + this.getTargetDescription() + " on " + this.elementToString(scope) + ", scope: [" + this.elementsToString(scopes, this.scopeIndex) + "]" + ", guards: " + Arrays.toString(this.guards), e);
        }
        catch (IllegalAccessException e) {
            throw new MustacheException("Error accessing " + this.getTargetDescription() + " on " + this.elementToString(scope) + ", scope: [" + this.elementsToString(scopes, this.scopeIndex) + "]" + ", guards: " + Arrays.toString(this.guards), e);
        }
        catch (InvocationTargetException e) {
            throw new MustacheException("Error invoking " + this.getTargetDescription() + " on " + this.elementToString(scope), e.getTargetException());
        }
        catch (Exception e) {
            throw new MustacheException("Error invoking " + this.getTargetDescription() + " on " + this.elementToString(scope), e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.field == null) {
            sb.append(this.method.toString());
            if (this.arguments != null) {
                for (Object arg : this.arguments) {
                    sb.append(",").append(arg);
                }
            }
        } else {
            sb.append(this.field);
        }
        return sb.toString();
    }

    public Wrapper[] getWrappers() {
        return this.wrappers;
    }

    private String getTargetDescription() {
        return this.method == null ? "field " + this.field.getDeclaringClass() + "." + this.field.getName() : "method " + this.method.getDeclaringClass().getCanonicalName() + "." + this.method.getName() + "(" + this.elementsToString(this.arguments, this.method.getParameterTypes().length - 1) + ")";
    }

    private String elementsToString(Object[] objects, int showUpTo) {
        if (objects == null || objects.length == 0 || showUpTo < 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= showUpTo && i < objects.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.elementToString(objects[i]));
        }
        return sb.toString();
    }

    private String elementToString(Object object) {
        return object == null ? null : object.getClass().getCanonicalName() + '@' + object.hashCode();
    }
}

