/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.servlet;

import io.honeybadger.org.apache.http.entity.ContentType;
import io.honeybadger.reporter.FeedbackForm;
import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HoneybadgerFilter
implements Filter {
    private NoticeReporter reporter;
    private FeedbackForm feedbackForm;
    private Properties properties = System.getProperties();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.setSysPropFromFilterConfig(filterConfig, "honeybadger.url");
        this.setSysPropFromFilterConfig(filterConfig, "honeybadger.api_key");
        this.setSysPropFromFilterConfig(filterConfig, "honeybadger.excluded_sys_props");
        this.setSysPropFromFilterConfig(filterConfig, "honeybadger.excluded_exception_classes");
        this.setSysPropFromFilterConfig(filterConfig, "honeybadger.application_package");
        this.setSysPropFromFilterConfig(filterConfig, "honeybadger.display_feedback_form");
        this.setSysPropFromFilterConfig(filterConfig, "honeybadger.feedback_form_template_path");
        this.reporter = new HoneybadgerReporter();
        this.feedbackForm = new FeedbackForm(HoneybadgerFilter.feedbackFormTemplatePath());
    }

    static String feedbackFormTemplatePath() {
        String templatePath = System.getProperty("honeybadger.feedback_form_template_path");
        if (templatePath == null || templatePath.isEmpty()) {
            return "templates/feedback-form.mustache";
        }
        return templatePath;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable e) {
            HttpServletRequest httpServletRequest;
            NoticeReportResult result = this.reporter.reportError(e, request);
            if (!this.displayFeedbackForm()) {
                throw e;
            }
            response.reset();
            if (request instanceof HttpServletRequest && this.acceptsOnlyJson(httpServletRequest = (HttpServletRequest)request)) {
                this.jsonError(result.getId(), response);
                return;
            }
            response.setContentType(ContentType.TEXT_HTML.getMimeType());
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                httpServletResponse.setStatus(500);
            }
            UUID errorId = result == null ? null : result.getId();
            this.feedbackForm.renderHtml(errorId, response.getWriter(), request.getLocale());
        }
    }

    protected boolean displayFeedbackForm() {
        String enabled = System.getProperty("honeybadger.display_feedback_form");
        if (enabled == null || enabled.isEmpty()) {
            return true;
        }
        return !enabled.equalsIgnoreCase("false") && !enabled.equalsIgnoreCase("off");
    }

    protected boolean acceptsOnlyJson(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaders("Accept");
        if (enumeration == null) {
            return false;
        }
        if (!enumeration.hasMoreElements()) {
            return false;
        }
        ArrayList accepts = Collections.list(enumeration);
        if (accepts.size() == 1) {
            return ((String)accepts.get(0)).equals(ContentType.APPLICATION_JSON.getMimeType());
        }
        return false;
    }

    protected void jsonError(UUID errorId, ServletResponse response) throws IOException {
        String json = String.format("{ error_id : \"%s\" }", errorId);
        response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        response.getWriter().append(json);
    }

    public void destroy() {
    }

    private void setSysPropFromFilterConfig(FilterConfig filterConfig, String param) {
        String val = filterConfig.getInitParameter(param);
        if (this.properties.getProperty(param) != null) {
            return;
        }
        if (val != null && !val.trim().equals("")) {
            this.properties.setProperty(param, val);
        }
    }

    NoticeReporter getReporter() {
        return this.reporter;
    }

    void setReporter(NoticeReporter reporter) {
        this.reporter = reporter;
    }

    public void setFeedbackForm(FeedbackForm feedbackForm) {
        this.feedbackForm = feedbackForm;
    }

    Properties getProperties() {
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }
}

