/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDetails
implements Serializable {
    private static final long serialVersionUID = 4689643321013504425L;
    private static Logger logger = LoggerFactory.getLogger(ServerDetails.class);
    public final String environment_name;
    public final String hostname;
    public final String project_root;

    public ServerDetails() {
        this.environment_name = ServerDetails.environment();
        this.hostname = ServerDetails.hostname();
        this.project_root = ServerDetails.projectRoot();
    }

    public ServerDetails(String environment_name, String hostname, String project_root) {
        this.environment_name = environment_name;
        this.hostname = hostname;
        this.project_root = project_root;
    }

    protected static String environment() {
        String hbEnv = System.getenv("HONEYBADGER_ENV");
        if (hbEnv != null && !hbEnv.isEmpty()) {
            return hbEnv;
        }
        String sysPropJavaEnv = System.getProperty("JAVA_ENV");
        if (sysPropJavaEnv != null && !sysPropJavaEnv.isEmpty()) {
            return sysPropJavaEnv;
        }
        String javaEnv = System.getenv("JAVA_ENV");
        if (javaEnv != null && !javaEnv.isEmpty()) {
            return javaEnv;
        }
        String sysPropEnv = System.getProperty("ENV");
        if (sysPropEnv != null && !sysPropEnv.isEmpty()) {
            return sysPropEnv;
        }
        String env = System.getenv("ENV");
        if (env != null && !env.isEmpty()) {
            return env;
        }
        return "development";
    }

    protected static String hostname() {
        String host;
        if (System.getenv("HOSTNAME") != null) {
            host = System.getenv("HOSTNAME");
        } else if (System.getenv("COMPUTERNAME") != null) {
            host = System.getenv("COMPUTERNAME");
        } else {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.error("Unable to find hostname", (Throwable)e);
                host = "unknown";
            }
        }
        return host;
    }

    protected static String projectRoot() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Can't get runtime root path", (Throwable)e);
            return "unknown";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerDetails that = (ServerDetails)o;
        if (this.environment_name != null ? !this.environment_name.equals(that.environment_name) : that.environment_name != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        return !(this.project_root == null ? that.project_root != null : !this.project_root.equals(that.project_root));
    }

    public int hashCode() {
        int result = this.environment_name != null ? this.environment_name.hashCode() : 0;
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.project_root != null ? this.project_root.hashCode() : 0);
        return result;
    }
}

