/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;

public class Details
extends LinkedHashMap<String, LinkedHashMap<String, String>>
implements Serializable {
    private static final long serialVersionUID = -6238693264237448645L;

    public Details() {
        this.addDefaultDetails();
    }

    protected void addDefaultDetails() {
        this.put("System Properties", Details.systemProperties());
        this.put("MDC Properties", Details.mdcProperties());
    }

    protected static LinkedHashMap<String, String> mdcProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map mdc = MDC.getCopyOfContextMap();
        if (mdc != null) {
            for (Map.Entry entry : mdc.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return map;
    }

    protected static LinkedHashMap<String, String> systemProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set<String> excludedSysProps = Details.buildExcludedSysProps();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (excludedSysProps.contains(entry.getKey().toString())) continue;
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }

    protected static Set<String> buildExcludedSysProps() {
        String excluded = System.getProperty("honeybadger.excluded_sys_props");
        HashSet<String> set = new HashSet<String>();
        set.add("honeybadger.api_key");
        set.add("honeybadger.excluded_sys_props");
        set.add("honeybadger.url");
        if (excluded == null || excluded.isEmpty()) {
            return set;
        }
        Collections.addAll(set, excluded.split(","));
        return set;
    }
}

