/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.github.mustachejava.util;

import io.honeybadger.com.github.mustachejava.MustacheException;
import java.io.IOException;
import java.io.Writer;

public class HtmlEscaper {
    public static void escape(String value, Writer writer, boolean escapeEscaped) {
        try {
            int position = 0;
            int length = value.length();
            block9: for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (c <= '\r') {
                    writer.append(value, position, i);
                    writer.append("&#");
                    writer.append(String.valueOf((int)c));
                    writer.append(";");
                    position = i + 1;
                    continue;
                }
                switch (c) {
                    case '&': {
                        if (!escapeEscaped && HtmlEscaper.matchesEntityRef(i + 1, length, value)) {
                            if (position == 0) continue block9;
                            position = HtmlEscaper.append(value, writer, position, i, "&");
                            continue block9;
                        }
                        position = HtmlEscaper.append(value, writer, position, i, "&amp;");
                        continue block9;
                    }
                    case '<': {
                        position = HtmlEscaper.append(value, writer, position, i, "&lt;");
                        continue block9;
                    }
                    case '>': {
                        position = HtmlEscaper.append(value, writer, position, i, "&gt;");
                        continue block9;
                    }
                    case '\"': {
                        position = HtmlEscaper.append(value, writer, position, i, "&quot;");
                        continue block9;
                    }
                    case '\'': {
                        position = HtmlEscaper.append(value, writer, position, i, "&#39;");
                    }
                }
            }
            writer.append(value, position, length);
        }
        catch (IOException e) {
            throw new MustacheException("Failed to encode value: " + value);
        }
    }

    private static int append(String value, Writer writer, int position, int i, String replace) throws IOException {
        writer.append(value, position, i);
        writer.append(replace);
        return i + 1;
    }

    private static boolean matchesEntityRef(int position, int length, String value) {
        for (int i = position; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case ';': {
                    return i != position;
                }
                case '#': {
                    return i == position && HtmlEscaper.matchesCharRef(i + 1, length, value);
                }
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i != position && c >= '0' && c <= '9') continue;
            return false;
        }
        return false;
    }

    private static boolean matchesCharRef(int position, int length, String value) {
        for (int i = position; i < length; ++i) {
            char c = value.charAt(i);
            if (c == ';') {
                return i != position;
            }
            if (c >= '0' && c <= '9' || c == 'x' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return false;
    }
}

