/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.validator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import io.hcxprotocol.createresource.HCXInsurancePlan;
import java.net.URL;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;

public class HCXFHIRValidator {
    private static HCXFHIRValidator instance = null;
    private FhirValidator validator = null;

    private HCXFHIRValidator() throws Exception {
        FhirContext fhirContext = FhirContext.forR4();
        fhirContext.setDefaultTypeForProfile("https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXInsurancePlan.html", HCXInsurancePlan.class);
        System.out.println("we have started");
        ValidationSupportChain supportChain = new ValidationSupportChain();
        DefaultProfileValidationSupport defaultSupport = new DefaultProfileValidationSupport(fhirContext);
        supportChain.addValidationSupport((IValidationSupport)defaultSupport);
        supportChain.addValidationSupport((IValidationSupport)new CommonCodeSystemsTerminologyService(fhirContext));
        supportChain.addValidationSupport((IValidationSupport)new InMemoryTerminologyServerValidationSupport(fhirContext));
        IParser parser = fhirContext.newJsonParser();
        String hcxIGBasePath = "https://ig.hcxprotocol.io/v0.7/";
        String nrcesIGBasePath = "https://nrces.in/ndhm/fhir/r4/";
        StructureDefinition sdCoverageEligibilityRequest = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-CoverageEligibilityRequest.json").openStream());
        StructureDefinition sdCoverageEligibilityResponse = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-CoverageEligibilityResponse.json").openStream());
        StructureDefinition sdClaim = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-Claim.json").openStream());
        StructureDefinition sdNRCESPatient = (StructureDefinition)parser.parseResource(new URL(nrcesIGBasePath + "StructureDefinition-Patient.json").openStream());
        StructureDefinition sdInsurancePlan = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-HCXInsurancePlan.json").openStream());
        StructureDefinition sdHCXProofOfIdentificationExtension = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-HCXProofOfIdentificationExtension.json").openStream());
        StructureDefinition sdHCXProofOfPresenceExtension = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-HCXProofOfPresenceExtension.json").openStream());
        StructureDefinition sdHCXDiagnosticDocumentsExtension = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-HCXDiagnosticDocumentsExtension.json").openStream());
        StructureDefinition sdHCXInformationalMessagesExtension = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-HCXInformationalMessagesExtension.json").openStream());
        StructureDefinition sdHCXQuestionnairesExtension = (StructureDefinition)parser.parseResource(new URL(hcxIGBasePath + "StructureDefinition-HCXQuestionnairesExtension.json").openStream());
        ValueSet vsProofOfIdentity = (ValueSet)parser.parseResource(new URL(hcxIGBasePath + "ValueSet-proof-of-identity-codes.json").openStream());
        ValueSet vsProofOfPresence = (ValueSet)parser.parseResource(new URL(hcxIGBasePath + "ValueSet-proof-of-presence-codes.json").openStream());
        ValueSet vsClinicalDiagnostics = (ValueSet)parser.parseResource(new URL(hcxIGBasePath + "ValueSet-clinical-diagnostics-document-codes.json").openStream());
        ValueSet vsInformationalMessages = (ValueSet)parser.parseResource(new URL(hcxIGBasePath + "ValueSet-informational-messages-codes.json").openStream());
        PrePopulatedValidationSupport prePopulatedSupport = new PrePopulatedValidationSupport(fhirContext);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdCoverageEligibilityRequest);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdCoverageEligibilityResponse);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdClaim);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdNRCESPatient);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdInsurancePlan);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdHCXProofOfIdentificationExtension);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdHCXProofOfPresenceExtension);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdHCXDiagnosticDocumentsExtension);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdHCXInformationalMessagesExtension);
        prePopulatedSupport.addStructureDefinition((IBaseResource)sdHCXQuestionnairesExtension);
        prePopulatedSupport.addValueSet((IBaseResource)vsClinicalDiagnostics);
        prePopulatedSupport.addValueSet((IBaseResource)vsInformationalMessages);
        prePopulatedSupport.addValueSet((IBaseResource)vsProofOfPresence);
        prePopulatedSupport.addValueSet((IBaseResource)vsProofOfIdentity);
        supportChain.addValidationSupport((IValidationSupport)prePopulatedSupport);
        CachingValidationSupport cache = new CachingValidationSupport((IValidationSupport)supportChain);
        FhirInstanceValidator validatorModule = new FhirInstanceValidator((IValidationSupport)cache);
        this.validator = fhirContext.newValidator().registerValidatorModule((IValidatorModule)validatorModule);
    }

    private static HCXFHIRValidator getInstance() throws Exception {
        if (null == instance) {
            instance = new HCXFHIRValidator();
        }
        return instance;
    }

    public static FhirValidator getValidator() throws Exception {
        return HCXFHIRValidator.getInstance().validator;
    }
}

